/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.nodes;

import it.krzeminski.snakeyaml.engine.kmp.common.UriEncoder;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/nodes/Tag;", "", "tag", "", "<init>", "(Ljava/lang/String;)V", "prefix", "(Ljava/lang/String;Ljava/lang/String;)V", "value", "getValue", "()Ljava/lang/String;", "toString", "equals", "", "other", "hashCode", "", "Companion", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nTag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tag.kt\nit/krzeminski/snakeyaml/engine/kmp/nodes/Tag\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,89:1\n1#2:90\n108#3:91\n80#3,22:92\n*S KotlinDebug\n*F\n+ 1 Tag.kt\nit/krzeminski/snakeyaml/engine/kmp/nodes/Tag\n*L\n25#1:91\n25#1:92,22\n*E\n"})
public final class Tag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    public static final String PREFIX = "tag:yaml.org,2002:";
    @JvmField
    @NotNull
    public static final Tag MERGE = new Tag("tag:yaml.org,2002:merge");
    @JvmField
    @NotNull
    public static final Tag SET = new Tag("tag:yaml.org,2002:set");
    @JvmField
    @NotNull
    public static final Tag BINARY = new Tag("tag:yaml.org,2002:binary");
    @JvmField
    @NotNull
    public static final Tag INT = new Tag("tag:yaml.org,2002:int");
    @JvmField
    @NotNull
    public static final Tag FLOAT = new Tag("tag:yaml.org,2002:float");
    @JvmField
    @NotNull
    public static final Tag BOOL = new Tag("tag:yaml.org,2002:bool");
    @JvmField
    @NotNull
    public static final Tag NULL = new Tag("tag:yaml.org,2002:null");
    @JvmField
    @NotNull
    public static final Tag STR = new Tag("tag:yaml.org,2002:str");
    @JvmField
    @NotNull
    public static final Tag SEQ = new Tag("tag:yaml.org,2002:seq");
    @JvmField
    @NotNull
    public static final Tag MAP = new Tag("tag:yaml.org,2002:map");
    @JvmField
    @NotNull
    public static final Tag COMMENT = new Tag("tag:yaml.org,2002:comment");
    @JvmField
    @NotNull
    public static final Tag ENV_TAG = new Tag("!ENV_VARIABLE");

    public Tag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!(((CharSequence)tag).length() > 0)) {
            boolean $i$a$-require-Tag$22 = false;
            String $i$a$-require-Tag$22 = "Tag must not be empty.";
            throw new IllegalArgumentException($i$a$-require-Tag$22.toString());
        }
        String $this$trim$iv = tag;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (!(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().length() == tag.length())) {
            boolean bl = false;
            String string = "Tag must not contain leading or trailing spaces.";
            throw new IllegalArgumentException(string.toString());
        }
        this.value = UriEncoder.encode(tag);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public Tag(@NotNull String prefix, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this(prefix + UriEncoder.encode(tag));
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Tag ? Intrinsics.areEqual((Object)this.value, (Object)((Tag)other).value) : false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/nodes/Tag$Companion;", "", "<init>", "()V", "PREFIX", "", "forType", "Lit/krzeminski/snakeyaml/engine/kmp/nodes/Tag;", "fqn", "MERGE", "SET", "BINARY", "INT", "FLOAT", "BOOL", "NULL", "STR", "SEQ", "MAP", "COMMENT", "ENV_TAG", "snakeyaml-engine-kmp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Tag forType(@NotNull String fqn) {
            Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
            return new Tag(Tag.PREFIX, fqn);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

