/*
 * Copyright (c) 2018, SnakeYAML
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.snakeyaml.engine.v2.events

import org.snakeyaml.engine.v2.exceptions.Mark
import kotlin.jvm.JvmOverloads

/**
 * Marks the end of a document.
 *
 * This event follows the document's content.
 */
class DocumentEndEvent @JvmOverloads constructor(
    val isExplicit: Boolean,
    startMark: Mark? = null,
    endMark: Mark? = null,
) : Event(startMark, endMark) {

    override val eventId: ID
        get() = ID.DocumentEnd

    override fun toString(): String {
        return buildString {
            append("-DOC")
            if (isExplicit) {
                append(" ...")
            }
        }
    }
}
