/*
 * Decompiled with CFR 0.152.
 */
package it.larusba.neo4j.jdbc.impl;

import it.larusba.neo4j.jdbc.Array;
import java.sql.SQLException;
import java.util.List;

public class ListArray
extends Array {
    private List list;
    private int type;

    public ListArray(List list, int type) {
        this.list = list;
        this.type = type;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        String name;
        if (!TYPES_SUPPORTED.contains(this.type)) {
            throw new SQLException("Type " + this.type + " not supported");
        }
        if (this.type == 12) {
            name = "VARCHAR";
        } else if (this.type == 4) {
            name = "INTEGER";
        } else if (this.type == 16) {
            name = "BOOLEAN";
        } else if (this.type == 8) {
            name = "DOUBLE";
        } else if (this.type == 2000) {
            name = "JAVA_OBJECT";
        } else {
            throw new SQLException("Type " + this.type + " not supported");
        }
        return name;
    }

    @Override
    public int getBaseType() throws SQLException {
        if (!TYPES_SUPPORTED.contains(this.type)) {
            throw new SQLException("Type " + this.type + " not supported");
        }
        return this.type;
    }

    @Override
    public Object getArray() throws SQLException {
        Object[] result;
        block8: {
            if (!TYPES_SUPPORTED.contains(this.type)) {
                throw new SQLException("Type " + this.type + " not supported");
            }
            try {
                if (this.type == 12) {
                    result = this.list.toArray(new String[this.list.size()]);
                    break block8;
                }
                if (this.type == 4) {
                    result = this.list.toArray(new Long[this.list.size()]);
                    break block8;
                }
                if (this.type == 16) {
                    result = this.list.toArray(new Boolean[this.list.size()]);
                    break block8;
                }
                if (this.type == 8) {
                    result = this.list.toArray(new Double[this.list.size()]);
                    break block8;
                }
                if (this.type == 2000) {
                    result = this.list.toArray(new Object[this.list.size()]);
                    break block8;
                }
                throw new SQLException("Type " + this.type + " not supported");
            }
            catch (ArrayStoreException e) {
                throw new SQLException(e);
            }
        }
        return result;
    }
}

