package it.micegroup.voila2runtime.mail.senders;

import java.io.ByteArrayOutputStream;

import javax.mail.internet.MimeMessage;

import org.springframework.mail.MailException;

import it.micegroup.voila2runtime.mail.rmi.MailService;
import it.micegroup.voila2runtime.mail.rmi.MimeMessageBean;

public class ServiceTransportMimeMailSenderImpl extends MimeMailSenderImpl {
	private MailService mailService;

	/**
	 * @return the mailService
	 */
	public MailService getMailService() {
		return mailService;
	}

	/**
	 * @param mailService the mailService to set
	 */
	public void setMailService(MailService mailService) {
		this.mailService = mailService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.springframework.mail.javamail.JavaMailSenderImpl#send(javax.mail.internet
	 * .MimeMessage)
	 */
	@Override
	public void send(MimeMessage mimeMessage) throws MailException {
		MimeMessageBean mimeMessageBean = new MimeMessageBean();
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try {
			mimeMessage.writeTo(baos);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		mimeMessageBean.setMimeMessage(baos.toByteArray());

		getMailService().sendMail(mimeMessageBean, getMailConfig().getMailConfigId());
	}
}
