/*
 * Decompiled with CFR 0.152.
 */
package it.mulders.stryker.pitreporter.dashboard.client;

import it.mulders.stryker.pitreporter.dashboard.client.StrykerDashboardClientException;
import it.mulders.stryker.pitreporter.environment.Environment;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pitest.util.Log;
import org.pitest.util.StringUtil;

public class StrykerDashboardClient {
    private static final Logger log = Log.getLogger();
    private final HttpClient client = HttpClient.newHttpClient();
    private final Environment environment;
    private final String hostname;

    public StrykerDashboardClient(Environment environment) {
        this(environment, "https://dashboard.stryker-mutator.io");
    }

    StrykerDashboardClient(Environment environment, String hostname) {
        this.environment = environment;
        this.hostname = hostname;
    }

    public void uploadReport(String report, String moduleName) throws StrykerDashboardClientException {
        String uri = this.constructReportUploadUri(moduleName);
        log.log(Level.INFO, "Uploading report to {0}", uri);
        String apiKey = this.environment.getApiKey();
        if (StringUtil.isNullOrEmpty((String)apiKey)) {
            log.log(Level.WARNING, "No API key configured!");
        } else if (log.isLoggable(Level.CONFIG)) {
            String maskedApiKey = StringUtil.repeat((char)'*', (int)7) + (apiKey.length() > 3 ? apiKey.substring(apiKey.length() - 3) : "***");
            log.log(Level.CONFIG, "Using API key {0}", maskedApiKey);
        }
        HttpRequest.BodyPublisher body = HttpRequest.BodyPublishers.ofString(report);
        HttpRequest request = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).header("Content-Type", "application/json").header("X-Api-Key", apiKey).uri(URI.create(uri)).PUT(body).build();
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            switch (statusCode) {
                case 200: {
                    log.log(Level.INFO, "Successfully uploaded report");
                    return;
                }
                case 401: {
                    log.log(Level.SEVERE, "Failed to upload report, please check your API key!");
                    this.logResponseBody(response);
                    throw new StrykerDashboardClientException("Please check your API key!");
                }
                case 404: {
                    log.log(Level.SEVERE, "Failed to upload report, please check your dashboard registration!");
                    this.logResponseBody(response);
                    throw new StrykerDashboardClientException("Please check your dashboard registration!");
                }
            }
            log.log(Level.SEVERE, "Unexpected response status: {0}", statusCode);
            this.logResponseBody(response);
            throw new StrykerDashboardClientException("Unknown error, please check the logs with --verbose before raising an issue");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "I/O error when sending the report or receiving the answer", e);
        }
        catch (InterruptedException e) {
            log.log(Level.SEVERE, "Sending the report or receiving the answer was interrupted", e);
            Thread.currentThread().interrupt();
        }
    }

    private void logResponseBody(HttpResponse<String> response) {
        log.log(Level.FINE, "API returned {0}", response.body());
    }

    private String constructReportUploadUri(String moduleName) {
        String projectName = this.environment.getProjectName();
        String projectVersion = this.environment.getProjectVersion();
        Object uri = String.format("%s/api/reports/%s/%s", this.hostname, projectName, projectVersion);
        if (moduleName != null) {
            uri = (String)uri + String.format("?module=%s", moduleName);
        }
        return uri;
    }
}

