/*
 * Decompiled with CFR 0.152.
 */
package it.mulders.stryker.pitreporter.environment;

import it.mulders.stryker.pitreporter.environment.Environment;
import it.mulders.stryker.pitreporter.environment.GithubActionsEnvironment;
import it.mulders.stryker.pitreporter.environment.UnknownEnvironment;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pitest.util.Log;

public class EnvironmentFactory {
    private static final Logger log = Log.getLogger();

    private EnvironmentFactory() {
    }

    public static Environment findEnvironment() {
        return EnvironmentFactory.findEnvironment(System.getenv());
    }

    static Environment findEnvironment(Map<String, String> environment) {
        if (environment.getOrDefault("GITHUB_ACTIONS", "false").equals("true")) {
            return new GithubActionsEnvironment();
        }
        log.log(Level.SEVERE, "Could not reliably determine your environment, this reporter will not work correctly.");
        log.log(Level.SEVERE, "Consider reporting an issue at https://github.com/mthmulders/pit-stryker-dashboard-reporter/issues/new.");
        return new UnknownEnvironment();
    }
}

