/*
 * Decompiled with CFR 0.152.
 */
package it.mulders.stryker.pitreporter;

import it.mulders.stryker.pitreporter.dashboard.client.StrykerDashboardClient;
import it.mulders.stryker.pitreporter.dashboard.client.StrykerDashboardClientException;
import it.mulders.stryker.pitreporter.environment.EnvironmentFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.ClassLines;
import org.pitest.elements.models.MutationTestSummaryData;
import org.pitest.elements.models.PackageSummaryMap;
import org.pitest.elements.utils.JsonParser;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.util.Log;
import org.pitest.util.PitError;

public class StrykerDashboardMutationResultListener
implements MutationResultListener {
    private static final Logger log = Log.getLogger();
    private final CodeSource codeSource;
    private final String moduleName;
    private final JsonParser jsonParser;
    private final PackageSummaryMap packageSummaryData = new PackageSummaryMap();
    private final StrykerDashboardClient dashboardClient;

    public StrykerDashboardMutationResultListener(CodeSource codeSource, String moduleName, SourceLocator ... locators) {
        this(codeSource, moduleName, new JsonParser(new HashSet<SourceLocator>(Arrays.asList(locators))), new StrykerDashboardClient(EnvironmentFactory.findEnvironment()));
    }

    StrykerDashboardMutationResultListener(CodeSource codeSource, String moduleName, JsonParser jsonParser, StrykerDashboardClient dashboardClient) {
        this.codeSource = codeSource;
        this.moduleName = moduleName;
        this.jsonParser = jsonParser;
        this.dashboardClient = dashboardClient;
    }

    PackageSummaryMap getPackageSummaryData() {
        return this.packageSummaryData;
    }

    public void runStart() {
    }

    private MutationTestSummaryData createSummaryData(ClassMutationResults classMutationResults) {
        String fileName = classMutationResults.getFileName();
        Collection mutations = classMutationResults.getMutations();
        ClassName className = classMutationResults.getMutatedClass();
        List classLines = this.codeSource.codeTrees().filter(classTree -> className.equals((Object)classTree.name())).map(ClassLines::fromTree).collect(Collectors.toList());
        return new MutationTestSummaryData(fileName, mutations, classLines);
    }

    public void handleMutationResult(ClassMutationResults metaData) {
        String packageName = metaData.getPackageName();
        this.packageSummaryData.update(packageName, this.createSummaryData(metaData));
    }

    public void runEnd() {
        try {
            String json = this.jsonParser.toJson(this.packageSummaryData);
            this.dashboardClient.uploadReport(json, this.moduleName);
        }
        catch (StrykerDashboardClientException ce) {
            throw new PitError("Failed to upload report", (Throwable)ce);
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, "Could not convert PIT results to Stryker Dashboard format", ioe);
        }
    }
}

