/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.builder;

import it.ness.queryable.model.QApi;
import it.ness.queryable.model.QMethodApi;
import it.ness.queryable.model.pojo.ApiDataPojo;
import it.ness.queryable.model.pojo.Parameters;
import it.ness.queryable.util.ModelFiles;
import it.ness.queryable.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class OpenApiBuilder {
    protected static String ANNOTATION_ID = "Id";

    public static void generateSources(ModelFiles mf, Log log, Parameters parameters, String packageName) throws Exception {
        String[] modelFiles = mf.getModelFileNames();
        ArrayList<ApiDataPojo> apiDataPojoList = new ArrayList<ApiDataPojo>();
        LinkedHashSet<String> classSet = new LinkedHashSet<String>();
        LinkedHashSet<String> simpleClassSet = new LinkedHashSet<String>();
        LinkedHashSet<String> enumPojoSet = new LinkedHashSet<String>();
        for (String string : modelFiles) {
            String className = StringUtil.getClassNameFromFileName(string);
            classSet.add(mf.getQualifiedClassName(className));
            simpleClassSet.add(className);
        }
        for (String string : modelFiles) {
            StringBuilder sb = new StringBuilder();
            String className = StringUtil.getClassNameFromFileName(string);
            String qualifiedClassName = mf.getQualifiedClassName(className);
            if (mf.excludeClass(className).booleanValue()) continue;
            try {
                ApiDataPojo apiDataPojo = OpenApiBuilder.readModel(log, string, parameters, qualifiedClassName);
                apiDataPojoList.add(apiDataPojo);
                enumPojoSet.addAll(OpenApiBuilder.getEnumPojoTypes(log, apiDataPojo, packageName, classSet, enumPojoSet));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (log != null) {
            log.info((CharSequence)("classSet : " + classSet));
        }
        LinkedHashSet toParseEnumPojoSet = new LinkedHashSet(enumPojoSet);
        for (int i = 1; toParseEnumPojoSet.size() > 0 && i <= 10; ++i) {
            if (log != null) {
                log.info((CharSequence)("parse iteration : " + i));
            }
            LinkedHashSet<String> newToParseEnumPojoSet = new LinkedHashSet<String>();
            for (String className : toParseEnumPojoSet) {
                ApiDataPojo apiDataPojo = OpenApiBuilder.readEnumPojo(log, className, parameters, packageName);
                Set<String> qualifiedNameSet = OpenApiBuilder.getEnumPojoTypes(log, apiDataPojo, packageName, classSet, enumPojoSet);
                for (String qualifiedName : qualifiedNameSet) {
                    if (enumPojoSet.contains(qualifiedName)) continue;
                    newToParseEnumPojoSet.add(qualifiedName);
                }
                apiDataPojoList.add(apiDataPojo);
            }
            enumPojoSet.addAll(newToParseEnumPojoSet);
            toParseEnumPojoSet.clear();
            toParseEnumPojoSet.addAll(newToParseEnumPojoSet);
        }
        for (String string : enumPojoSet) {
            apiDataPojoList.add(OpenApiBuilder.readEnumPojo(log, string, parameters, packageName));
        }
        if (log != null) {
            log.info((CharSequence)("apiDataPojoList size : " + apiDataPojoList.size()));
        }
        for (ApiDataPojo apiDataPojo : apiDataPojoList) {
            OpenApiBuilder.print(log, apiDataPojo, classSet, simpleClassSet, enumPojoSet);
        }
        for (ApiDataPojo apiDataPojo : apiDataPojoList) {
            OpenApiBuilder.printServices(log, apiDataPojo, classSet, simpleClassSet, enumPojoSet);
        }
        for (ApiDataPojo apiDataPojo : apiDataPojoList) {
            OpenApiBuilder.printComponents(log, apiDataPojo, classSet, simpleClassSet, enumPojoSet);
        }
        if (log != null) {
            log.info((CharSequence)"Done generating openapi sources");
        }
    }

    private List<String> getServiceRsFiles(Path filePath) throws IOException {
        try (Stream<Path> walk = Files.walk(filePath, new FileVisitOption[0]);){
            List<String> list = walk.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(Path::toString).filter(f -> f.endsWith("ServiceRs.java")).collect(Collectors.toList());
            return list;
        }
    }

    private static void printServices(Log log, ApiDataPojo apiDataPojo, Set<String> classSet, Set<String> simpleClassSet, Set<String> enumPojoSet) {
        if (apiDataPojo.rsPath == null) {
            return;
        }
        if (log != null) {
            log.info((CharSequence)"******************** printServices ");
        }
        if (log != null) {
            log.info((CharSequence)OpenApiBuilder.getListMethod(log, apiDataPojo, classSet, simpleClassSet, enumPojoSet));
        }
    }

    private static void printComponents(Log log, ApiDataPojo apiDataPojo, Set<String> classSet, Set<String> simpleClassSet, Set<String> enumPojoSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n%s:\n", apiDataPojo.className));
        if (apiDataPojo.qualifiedClassName.contains("enum")) {
            sb.append(OpenApiBuilder.getIndent(1) + "enum:\n");
            for (QApi qApi : apiDataPojo.apiFieldList) {
                String enumName = qApi.enumField.getName();
                sb.append(OpenApiBuilder.getIndent(3) + String.format("- %s:\n", enumName));
            }
            sb.append(OpenApiBuilder.getIndent(1) + "type: string\n");
        } else {
            sb.append(OpenApiBuilder.getIndent(1) + "type : object\n");
            sb.append(OpenApiBuilder.getIndent(2) + "properties:\n");
            for (QApi qApi : apiDataPojo.apiFieldList) {
                String fieldName = qApi.field.getName();
                String fieldType = qApi.field.getType().getName();
                String fieldQualifiedType = qApi.field.getType().getQualifiedName();
                sb.append(OpenApiBuilder.getIndent(3) + String.format("%s:\n", fieldName));
                String openApiType = OpenApiBuilder.getOpenApiType(fieldType);
                String openApiFormat = OpenApiBuilder.getOpenApiFormat(fieldType);
                if (openApiType != null) {
                    sb.append(OpenApiBuilder.getIndent(4) + String.format("type: %s\n", openApiType));
                    if (openApiFormat == null) continue;
                    sb.append(OpenApiBuilder.getIndent(4) + String.format("format: %s\n", openApiFormat));
                    continue;
                }
                sb.append(OpenApiBuilder.getIndent(4) + String.format("$ref: '#/components/schemas/%s'\n", fieldType));
            }
        }
        if (log != null) {
            log.info((CharSequence)sb.toString());
        }
    }

    private static void print(Log log, ApiDataPojo apiDataPojo, Set<String> classSet, Set<String> simpleClassSet, Set<String> enumPojoSet) {
        if (log != null) {
            log.info((CharSequence)("qualifiedClassName : " + apiDataPojo.qualifiedClassName));
        }
        for (QApi qApiField : apiDataPojo.apiFieldList) {
            if (qApiField.field != null) {
                FieldSource<JavaClassSource> field = qApiField.field;
                Type fieldType = field.getType();
                String fieldTypeName = fieldType.getName();
                List<AnnotationSource<JavaClassSource>> list = qApiField.annotations;
                String fieldName = qApiField.field.getName();
                String simpleType = OpenApiBuilder.isKnownSimpleType((Type<JavaClassSource>)fieldType);
                if (qApiField.isId && log != null) {
                    log.info((CharSequence)("id field : " + fieldName));
                }
                if (simpleType != null) {
                    if (log == null) continue;
                    log.info((CharSequence)("simple type : " + qApiField.field.getType().getName() + " : " + fieldName));
                    continue;
                }
                if (fieldTypeName.equals("List") || fieldTypeName.equals("Set")) {
                    Type param = (Type)qApiField.field.getType().getTypeArguments().get(0);
                    String paramSimpleType = OpenApiBuilder.isKnownSimpleType((Type<JavaClassSource>)param);
                    if (paramSimpleType != null) {
                        if (log == null) continue;
                        log.info((CharSequence)("simple type list : " + param.getName() + " : " + fieldName));
                        continue;
                    }
                    if (classSet.contains(param.getQualifiedName())) {
                        if (log == null) continue;
                        log.info((CharSequence)("complex type list : " + param.getQualifiedName() + " : " + fieldName));
                        continue;
                    }
                    if (enumPojoSet.contains(param.getQualifiedName())) {
                        if (log == null) continue;
                        log.info((CharSequence)("complex type list : " + param.getQualifiedName() + " : " + fieldName));
                        continue;
                    }
                    if (simpleClassSet.contains(param.getName())) {
                        if (log == null) continue;
                        log.info((CharSequence)("complex type list : " + param.getName() + " : " + fieldName));
                        continue;
                    }
                    throw new RuntimeException("ERROR: not know type: " + param.getQualifiedName());
                }
                if (classSet.contains(fieldType.getQualifiedName())) {
                    if (log == null) continue;
                    log.info((CharSequence)("complex type : " + fieldType.getQualifiedName() + " : " + fieldName));
                    continue;
                }
                if (enumPojoSet.contains(fieldType.getQualifiedName())) {
                    if (log == null) continue;
                    log.info((CharSequence)("complex type : " + fieldType.getQualifiedName() + " : " + fieldName));
                    continue;
                }
                if (simpleClassSet.contains(fieldType.getName())) {
                    if (log == null) continue;
                    log.info((CharSequence)("complex type list : " + fieldType.getName() + " : " + fieldName));
                    continue;
                }
                throw new RuntimeException("ERROR: not know type: " + fieldType.getQualifiedName());
            }
            String fieldName = qApiField.enumField.getName();
            if (log == null) continue;
            log.info((CharSequence)("enum type : " + fieldName));
        }
        if (apiDataPojo.apiMethodList == null || apiDataPojo.apiMethodList.size() == 0) {
            return;
        }
        if (log != null) {
            log.info((CharSequence)"****************method list ");
        }
        for (QMethodApi qMethodApi : apiDataPojo.apiMethodList) {
            if (qMethodApi.methodPath == null || log == null) continue;
            log.info((CharSequence)("methodPath : " + qMethodApi.methodPath));
        }
        if (apiDataPojo.filterDefs != null && apiDataPojo.filterDefs.size() > 0) {
            log.info((CharSequence)("filterDefs : " + apiDataPojo.filterDefs));
        }
    }

    private static String isKnownSimpleType(Type<JavaClassSource> fieldType) {
        String fieldTypeName = fieldType.getName();
        String fieldTypeQualifiedName = fieldType.getQualifiedName();
        if (fieldTypeName.equals("String")) {
            return fieldTypeName;
        }
        if (fieldTypeName.equalsIgnoreCase("int") || fieldTypeName.equalsIgnoreCase("integer") || fieldTypeName.equalsIgnoreCase("long") || fieldTypeName.equalsIgnoreCase("boolean") || fieldTypeName.equalsIgnoreCase("double") || fieldTypeName.equalsIgnoreCase("float")) {
            return fieldTypeName;
        }
        if ("LocalDateTime".equals(fieldTypeName) || "LocalDate".equals(fieldTypeName) || "java.util.Date".equals(fieldTypeQualifiedName)) {
            return fieldTypeName;
        }
        if (fieldTypeName.equals("BigDecimal")) {
            return fieldTypeName;
        }
        if (fieldTypeName.equals("BigInteger")) {
            return fieldTypeName;
        }
        return null;
    }

    private static boolean isKnownSimpleType(String fieldTypeName) {
        if (fieldTypeName.equalsIgnoreCase("String")) {
            return true;
        }
        if (fieldTypeName.equalsIgnoreCase("int") || fieldTypeName.equalsIgnoreCase("integer") || fieldTypeName.equalsIgnoreCase("long") || fieldTypeName.equalsIgnoreCase("boolean") || fieldTypeName.equalsIgnoreCase("double") || fieldTypeName.equalsIgnoreCase("float")) {
            return true;
        }
        if ("LocalDateTime".equals(fieldTypeName) || "LocalDate".equals(fieldTypeName) || "java.util.Date".equals(fieldTypeName)) {
            return true;
        }
        if (fieldTypeName.equals("BigDecimal")) {
            return true;
        }
        return fieldTypeName.equals("BigInteger");
    }

    private static String getOpenApiType(String fieldTypeName) {
        if (fieldTypeName.equalsIgnoreCase("String")) {
            return "string";
        }
        if (fieldTypeName.equalsIgnoreCase("int") || fieldTypeName.equalsIgnoreCase("integer") || fieldTypeName.equalsIgnoreCase("long")) {
            return "integer";
        }
        if (fieldTypeName.equalsIgnoreCase("double") || fieldTypeName.equalsIgnoreCase("float")) {
            return "number";
        }
        if (fieldTypeName.equalsIgnoreCase("boolean")) {
            return "boolean";
        }
        if ("LocalDateTime".equals(fieldTypeName) || "LocalDate".equals(fieldTypeName) || "java.util.Date".equals(fieldTypeName)) {
            return "string";
        }
        if (fieldTypeName.equals("BigDecimal")) {
            return "number";
        }
        if (fieldTypeName.equals("BigInteger")) {
            return "integer";
        }
        return null;
    }

    private static String getOpenApiFormat(String fieldTypeName) {
        if (fieldTypeName.equalsIgnoreCase("String")) {
            return null;
        }
        if (fieldTypeName.equalsIgnoreCase("int") || fieldTypeName.equalsIgnoreCase("integer")) {
            return "int32";
        }
        if (fieldTypeName.equalsIgnoreCase("long")) {
            return "int64";
        }
        if (fieldTypeName.equalsIgnoreCase("double")) {
            return "double";
        }
        if (fieldTypeName.equalsIgnoreCase("float")) {
            return "float";
        }
        if (fieldTypeName.equalsIgnoreCase("boolean")) {
            return null;
        }
        if ("LocalDateTime".equals(fieldTypeName)) {
            return "date-time";
        }
        if ("LocalDate".equals(fieldTypeName) || "java.util.Date".equals(fieldTypeName)) {
            return "date";
        }
        if (fieldTypeName.equals("BigDecimal")) {
            return "double";
        }
        if (fieldTypeName.equals("BigInteger")) {
            return "int64";
        }
        return null;
    }

    private static Set<String> getEnumPojoTypes(Log log, ApiDataPojo apiDataPojo, String packageName, Set<String> classSet, Set<String> enumPojoSet) {
        LinkedHashSet<String> pojoEnumSet = new LinkedHashSet<String>();
        for (QApi qApiField : apiDataPojo.apiFieldList) {
            Type param;
            String paramQualifiedName;
            if (qApiField.field == null) continue;
            String fieldTypeName = qApiField.field.getType().getQualifiedName();
            String fieldName = qApiField.field.getName();
            if (fieldTypeName.startsWith(packageName + ".model")) {
                if (log != null) {
                    log.info((CharSequence)(fieldTypeName + " : " + fieldName));
                }
                if (classSet.contains(fieldTypeName) || enumPojoSet.contains(fieldTypeName)) continue;
                pojoEnumSet.add(fieldTypeName);
                continue;
            }
            if (!qApiField.field.getType().getName().equals("List") && !qApiField.field.getType().getName().equals("Set")) continue;
            if (log != null) {
                log.info((CharSequence)(qApiField.field.getType().getName() + " : " + fieldName));
            }
            if (!(paramQualifiedName = (param = (Type)qApiField.field.getType().getTypeArguments().get(0)).getQualifiedName()).startsWith(packageName + ".model")) continue;
            if (log != null) {
                log.info((CharSequence)(paramQualifiedName + " : " + fieldName));
            }
            if (classSet.contains(paramQualifiedName) || enumPojoSet.contains(paramQualifiedName)) continue;
            pojoEnumSet.add(paramQualifiedName);
        }
        return pojoEnumSet;
    }

    private static ApiDataPojo readModel(Log log, String modelFileName, Parameters parameters, String qualifiedClassName) throws Exception {
        String path = parameters.modelPath;
        JavaClassSource javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)new File(path, modelFileName));
        List fieldsList = javaClass.getFields();
        ApiDataPojo apiDataPojo = new ApiDataPojo();
        apiDataPojo.qualifiedClassName = qualifiedClassName;
        apiDataPojo.className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        apiDataPojo.filterDefs = new HashMap<String, String>();
        for (AnnotationSource anno : javaClass.getAnnotations()) {
            if (anno.getName().equals("QRs")) {
                apiDataPojo.rsPath = OpenApiBuilder.getConstantValue(log, parameters, anno.getStringValue(), javaClass);
            }
            if (!anno.getName().equals("FilterDef")) continue;
            Object filterName = anno.getStringValue("name");
            AnnotationSource filterParameter = anno.getAnnotationValue("parameters");
            String paramName = filterParameter.getStringValue("name");
            String paramType = filterParameter.getStringValue("type");
            String[] filterNamesToken = ((String)filterName).split("\\.");
            if (filterNamesToken.length > 1) {
                filterName = filterNamesToken[filterNamesToken.length - 2] + "." + filterNamesToken[filterNamesToken.length - 1];
            }
            String ref = null;
            if (apiDataPojo.apiFieldList != null && apiDataPojo.apiFieldList.size() > 0) {
                String fieldName = ((String)filterName).substring(((String)filterName).indexOf(46) + 1);
                for (QApi qApis : apiDataPojo.apiFieldList) {
                    if (!qApis.field.getName().equals(fieldName) || qApis.enumField == null) continue;
                    ref = qApis.enumField.getName();
                }
            }
            if (ref == null) {
                apiDataPojo.filterDefs.put((String)filterName, paramType);
                continue;
            }
            apiDataPojo.filterDefs.put((String)filterName, ref);
        }
        apiDataPojo.apiFieldList = new ArrayList<QApi>();
        for (FieldSource field : fieldsList) {
            List list;
            QApi qApiField = OpenApiBuilder.getDefaultsField((FieldSource<JavaClassSource>)field, list = field.getAnnotations());
            if (qApiField == null) continue;
            apiDataPojo.apiFieldList.add(qApiField);
        }
        String serviceFileName = modelFileName.substring(0, modelFileName.length() - ".java".length()) + "ServiceRs.java";
        JavaClassSource javaServiceRsClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)new File(parameters.serviceRsPath, serviceFileName));
        apiDataPojo.apiMethodList = new ArrayList<QMethodApi>();
        List methodsList = javaServiceRsClass.getMethods();
        for (MethodSource method : methodsList) {
            List methodAnnotations = method.getAnnotations();
            boolean isRsMethod = false;
            String methodPath = null;
            for (AnnotationSource anno : methodAnnotations) {
                if (anno.getName().equalsIgnoreCase("GET") || anno.getName().equalsIgnoreCase("POST") || anno.getName().equalsIgnoreCase("PUT") || anno.getName().equalsIgnoreCase("DELETE")) {
                    isRsMethod = true;
                }
                if (!anno.getName().equalsIgnoreCase("Path")) continue;
                methodPath = anno.getStringValue();
            }
            if (!isRsMethod) continue;
            List methodParameters = method.getParameters();
            QMethodApi qMethodApi = new QMethodApi();
            qMethodApi.methodParameters = methodParameters;
            qMethodApi.methodAnnotations = methodAnnotations;
            qMethodApi.methodPath = methodPath;
            apiDataPojo.apiMethodList.add(qMethodApi);
            if (log == null) continue;
            log.info((CharSequence)(" ****** qMethodApi : " + qMethodApi));
        }
        return apiDataPojo;
    }

    private static ApiDataPojo readEnumPojo(Log log, String className, Parameters parameters, String packageName) throws Exception {
        String classPath = className.substring(packageName.length() + ".model".length());
        String filePath = parameters.modelPath + classPath.replaceAll("\\.", "/") + ".java";
        if (log != null) {
            log.info((CharSequence)(" className : " + className + " filePath :" + filePath));
        }
        try {
            ApiDataPojo apiDataPojo = new ApiDataPojo();
            apiDataPojo.qualifiedClassName = className;
            apiDataPojo.className = className.substring(className.lastIndexOf(46) + 1);
            JavaClassSource javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)new File(filePath));
            List fieldsList = javaClass.getFields();
            apiDataPojo.apiFieldList = new ArrayList<QApi>();
            for (FieldSource field : fieldsList) {
                List list;
                QApi qApiField = OpenApiBuilder.getDefaultsField((FieldSource<JavaClassSource>)field, list = field.getAnnotations());
                if (qApiField == null) continue;
                if (log != null) {
                    log.info((CharSequence)(" qApiField : " + qApiField));
                }
                apiDataPojo.apiFieldList.add(qApiField);
            }
            return apiDataPojo;
        }
        catch (Exception apiDataPojo) {
            ApiDataPojo apiDataPojo2 = new ApiDataPojo();
            apiDataPojo2.qualifiedClassName = className;
            apiDataPojo2.className = className.substring(className.lastIndexOf(46) + 1);
            JavaEnumSource javaClass = (JavaEnumSource)Roaster.parse(JavaEnumSource.class, (File)new File(filePath));
            List fieldsList = javaClass.getEnumConstants();
            apiDataPojo2.apiFieldList = new ArrayList<QApi>();
            for (EnumConstantSource field : fieldsList) {
                QApi qApiField = OpenApiBuilder.getDefaultsField(field);
                apiDataPojo2.apiFieldList.add(qApiField);
            }
            return apiDataPojo2;
        }
    }

    public static QApi getDefaultsField(FieldSource<JavaClassSource> field, List<AnnotationSource<JavaClassSource>> list) {
        if (field.isPublic() && field.isStatic() && field.isFinal()) {
            return null;
        }
        if (field.isTransient() || field.isVolatile()) {
            return null;
        }
        boolean isId = false;
        if (list != null && list.size() > 0) {
            for (AnnotationSource<JavaClassSource> anno : list) {
                if (!anno.getName().equals(ANNOTATION_ID)) continue;
                isId = true;
            }
        }
        QApi qApiField = new QApi();
        qApiField.field = field;
        qApiField.annotations = list;
        qApiField.isId = isId;
        return qApiField;
    }

    public static QApi getDefaultsField(EnumConstantSource field) {
        boolean isId = false;
        QApi qApiField = new QApi();
        qApiField.enumField = field;
        qApiField.annotations = null;
        qApiField.isId = isId;
        return qApiField;
    }

    public static String getPath() {
        return null;
    }

    public static String getListMethod(Log log, ApiDataPojo apiDataPojo, Set<String> classSet, Set<String> simpleClassSet, Set<String> enumPojoSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("\npaths:\n");
        sb.append(OpenApiBuilder.getIndent(1) + String.format("%s\n", apiDataPojo.rsPath));
        sb.append(OpenApiBuilder.getIndent(2) + "get:\n");
        sb.append(OpenApiBuilder.getIndent(3) + String.format("summary: Ritorna la lista degli %s\n", apiDataPojo.className));
        sb.append(OpenApiBuilder.getIndent(3) + "tags:\n");
        sb.append(OpenApiBuilder.getIndent(4) + String.format("- %s\n", apiDataPojo.className));
        sb.append(OpenApiBuilder.getIndent(3) + "parameters:\n");
        OpenApiBuilder.getQueryParam(sb, "orderBy", null, null, null, "false", "string", "description: ordinamento della query (compreso di ASC/DESC)");
        OpenApiBuilder.getQueryParam(sb, "startRow", null, "int32", "0", "false", "integer", "offset per la paginazione ");
        if (apiDataPojo.filterDefs != null && apiDataPojo.filterDefs.size() > 0) {
            Set<String> keySet = apiDataPojo.filterDefs.keySet();
            for (String key : keySet) {
                String fieldType = apiDataPojo.filterDefs.get(key);
                String ref = null;
                String format = null;
                if (OpenApiBuilder.isKnownSimpleType(fieldType)) {
                    format = fieldType;
                } else {
                    ref = fieldType;
                }
                OpenApiBuilder.getQueryParam(sb, key, ref, format, null, "false", null, null);
            }
        }
        sb.append(OpenApiBuilder.getListResponse(log, apiDataPojo, classSet, simpleClassSet, enumPojoSet));
        return sb.toString();
    }

    public static String getListResponse(Log log, ApiDataPojo apiDataPojo, Set<String> classSet, Set<String> simpleClassSet, Set<String> enumPojoSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenApiBuilder.getIndent(3) + "responses:\n");
        sb.append(OpenApiBuilder.getIndent(4) + "'200':\n");
        sb.append(OpenApiBuilder.getIndent(4) + "description: OK\n");
        sb.append(OpenApiBuilder.getIndent(4) + "headers:\n");
        sb.append(OpenApiBuilder.getIndent(5) + "listSize:\n");
        sb.append(OpenApiBuilder.getIndent(6) + "description: il numero di elementi restituiti dalla chiamata\n");
        sb.append(OpenApiBuilder.getIndent(6) + "schema:\n");
        sb.append(OpenApiBuilder.getIndent(7) + "type: integer\n");
        sb.append(OpenApiBuilder.getIndent(5) + "startRow:\n");
        sb.append(OpenApiBuilder.getIndent(6) + "description: l'offset per la paginazione\n");
        sb.append(OpenApiBuilder.getIndent(6) + "schema:\n");
        sb.append(OpenApiBuilder.getIndent(7) + "type: integer\n");
        sb.append(OpenApiBuilder.getIndent(5) + "pageSize:\n");
        sb.append(OpenApiBuilder.getIndent(6) + "description: il numero di elementi per pagina \n");
        sb.append(OpenApiBuilder.getIndent(6) + "schema:\n");
        sb.append(OpenApiBuilder.getIndent(7) + "type: integer\n");
        sb.append(OpenApiBuilder.getIndent(4) + "content:\n");
        sb.append(OpenApiBuilder.getIndent(5) + "application/json:\n");
        sb.append(OpenApiBuilder.getIndent(6) + "schema\n");
        sb.append(OpenApiBuilder.getIndent(7) + String.format("$ref: '#/components/schemas/%s'\n", apiDataPojo.className));
        sb.append(OpenApiBuilder.getIndent(3) + "security:\n");
        sb.append(OpenApiBuilder.getIndent(4) + "- kimeraToken: []\n");
        return sb.toString();
    }

    public static void getQueryParam(StringBuilder sb, String name, String ref, String format, String defaultValue, String required, String type, String description) {
        sb.append(OpenApiBuilder.getIndent(4) + String.format("- name: %s\n", name));
        sb.append(OpenApiBuilder.getIndent(5) + "in: query\n");
        sb.append(OpenApiBuilder.getIndent(5) + "schema:\n");
        if (ref != null) {
            sb.append(OpenApiBuilder.getIndent(6) + String.format("$ref: '#/components/schemas/%s'\n", ref));
        }
        if (format != null) {
            sb.append(OpenApiBuilder.getIndent(6) + String.format("format: %s\n", format));
        }
        if (defaultValue != null) {
            sb.append(OpenApiBuilder.getIndent(6) + String.format("default: \"%s\"\n", defaultValue));
        }
        if (type != null) {
            sb.append(OpenApiBuilder.getIndent(6) + String.format("type: %s\n", type));
        }
        if (required != null) {
            sb.append(OpenApiBuilder.getIndent(5) + String.format("required: %s\n", required));
        }
        if (description != null) {
            sb.append(OpenApiBuilder.getIndent(5) + String.format("description: %s\n", description));
        }
    }

    public static String getIndent(int level) {
        return " ".repeat(Math.max(0, level * 2));
    }

    private static String getConstantValue(Log log, Parameters parameters, String constantName, JavaClassSource javaClass) {
        for (Import imp : javaClass.getImports()) {
            String constantImport = imp.getQualifiedName();
            if (!constantImport.endsWith(constantName)) continue;
            String filePath = parameters.serviceRsPath;
            String constantPath = filePath.substring("src/main/java/".length(), filePath.length() - "/service/rs".length()).replaceAll("/", "\\.");
            String subConstantPath = constantImport.replaceAll(constantPath, "").substring(1);
            String[] tokens = subConstantPath.split("\\.");
            StringBuilder appConstantFilePath = new StringBuilder(parameters.serviceRsPath.substring(0, parameters.serviceRsPath.length() - "/service/rs".length()));
            for (int i = 0; i < tokens.length - 1; ++i) {
                appConstantFilePath.append("/").append(tokens[i]);
            }
            appConstantFilePath.append(".java");
            try {
                JavaClassSource javaAppContantsClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)new File(appConstantFilePath.toString()));
                HashMap<String, String> constantsMap = new HashMap<String, String>();
                for (int i = 1; i < 10; ++i) {
                    for (FieldSource field : javaAppContantsClass.getFields()) {
                        String fieldName = field.getName().trim();
                        if (constantsMap.containsKey(fieldName)) continue;
                        String fieldDeclaration = field.toString().split("=")[1];
                        if (!fieldDeclaration.contains("+")) {
                            fieldDeclaration = fieldDeclaration.replaceAll("\"", "").replaceAll(";", "").trim();
                            constantsMap.put(fieldName, fieldDeclaration);
                            continue;
                        }
                        String[] fieldTokens = fieldDeclaration.split("\\+");
                        boolean allFieldsFound = true;
                        for (String fToken : fieldTokens) {
                            if ((fToken = fToken.trim()).contains("\"") || constantsMap.containsKey(fToken)) continue;
                            allFieldsFound = false;
                            break;
                        }
                        if (!allFieldsFound) continue;
                        StringBuilder sb = new StringBuilder();
                        for (String fToken : fieldTokens) {
                            if ((fToken = fToken.trim()).contains("\"")) {
                                sb.append(fToken.replaceAll("\"", "").replaceAll(";", "").trim());
                                continue;
                            }
                            sb.append((String)constantsMap.get(fToken));
                        }
                        constantsMap.put(fieldName, sb.toString());
                    }
                }
                if (log != null) {
                    log.info((CharSequence)(" constantName :" + (String)constantsMap.get(constantName)));
                }
                return (String)constantsMap.get(constantName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

