/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.builder;

import it.ness.queryable.model.FilterDefBase;
import it.ness.queryable.model.QLikeListFilterDef;
import it.ness.queryable.model.enums.FilterType;
import it.ness.queryable.model.pojo.Data;
import it.ness.queryable.model.pojo.Parameters;
import it.ness.queryable.templates.FreeMarkerTemplates;
import it.ness.queryable.util.GetSearchMethod;
import it.ness.queryable.util.ModelFiles;
import it.ness.queryable.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class QueryableBuilder {
    public static void generateSources(ModelFiles mf, Log log, Parameters parameters) throws Exception {
        String[] modelFiles;
        for (String modelFileName : modelFiles = mf.getModelFileNames()) {
            String className = StringUtil.getClassNameFromFileName(modelFileName);
            if (mf.excludeClass(className).booleanValue()) continue;
            try {
                QueryableBuilder.createModel(log, mf, modelFileName, parameters);
                String orderBy = mf.getDefaultOrderBy(className);
                String rsPath = mf.getRsPath(className);
                QueryableBuilder.createRsService(mf, className, parameters.groupId, parameters.artifactId, orderBy, rsPath, parameters, log);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (log != null) {
            log.info((CharSequence)"Done generating sources");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createModel(Log log, ModelFiles mf, String modelFileName, Parameters parameters) throws Exception {
        String className = StringUtil.getClassNameFromFileName(modelFileName);
        String path = parameters.modelPath;
        JavaClassSource javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)new File(path, modelFileName));
        LinkedHashSet<FilterDefBase> allFilderDefs = new LinkedHashSet<FilterDefBase>();
        Set<FilterDefBase> preQueryDefs = mf.getFilterDef(className, FilterType.PREQUERY);
        Set<FilterDefBase> postQueryDefs = mf.getFilterDef(className, FilterType.POSTQUERY);
        if (null != preQueryDefs) {
            allFilderDefs.addAll(preQueryDefs);
        }
        if (null != postQueryDefs) {
            allFilderDefs.addAll(postQueryDefs);
        }
        if (allFilderDefs.size() == 0) {
            if (log != null) {
                log.debug((CharSequence)("Not defined Q filterdefs for class : " + className));
            }
            return;
        }
        if (log != null) {
            log.debug((CharSequence)("Creating model for class : " + className));
        }
        javaClass.addImport("org.hibernate.annotations.Filter");
        javaClass.addImport("org.hibernate.annotations.FilterDef");
        javaClass.addImport("org.hibernate.annotations.ParamDef");
        for (FilterDefBase fd : allFilderDefs) {
            fd.addAnnotationToModelClass(javaClass);
        }
        if (javaClass.hasImport("org.hibernate.annotations")) {
            javaClass.removeImport("org.hibernate.annotations.Filter");
            javaClass.removeImport("org.hibernate.annotations.FilterDef");
            javaClass.removeImport("org.hibernate.annotations.ParamDef");
        }
        String packagePath = QueryableBuilder.getPathFromPackage(javaClass.getPackage());
        File pd = new File(parameters.outputDirectory, packagePath);
        pd.mkdirs();
        FileWriter out = new FileWriter(new File(pd, modelFileName));
        try {
            out.append(javaClass.toString());
        }
        finally {
            out.flush();
            out.close();
        }
    }

    private static void createRsService(ModelFiles mf, String className, String groupId, String artefactId, String orderBy, String rsPath, Parameters parameters, Log log) throws Exception {
        Data data = Data.with("packageName", groupId + "." + artefactId).and("groupId", groupId).and("className", className);
        if (orderBy != null && !"NOT_SET".equals(orderBy)) {
            data = data.and("defaultSort", orderBy);
        }
        if (rsPath != null && !"NOT_SET".equals(rsPath)) {
            data = data.and("rsPath", rsPath);
        }
        Map<String, Object> map = data.map();
        String serviceRsClass = FreeMarkerTemplates.processTemplate("servicers", map);
        JavaClassSource javaClassTemplate = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)serviceRsClass);
        Set<FilterDefBase> preQueryFilters = mf.getFilterDef(className, FilterType.PREQUERY);
        Set<FilterDefBase> postQueryFilters = mf.getFilterDef(className, FilterType.POSTQUERY);
        GetSearchMethod getSearchMethod = new GetSearchMethod(log, preQueryFilters, postQueryFilters, className);
        QueryableBuilder.addImportsToClass(javaClassTemplate, preQueryFilters, groupId);
        QueryableBuilder.addImportsToClass(javaClassTemplate, postQueryFilters, groupId);
        MethodSource<JavaClassSource> templateMethod = QueryableBuilder.getMethodByName(javaClassTemplate, "getSearch");
        templateMethod.setBody(getSearchMethod.create());
        String packagePath = QueryableBuilder.getPathFromPackage(javaClassTemplate.getPackage());
        File pd = new File(parameters.outputDirectory, packagePath);
        File filePath = new File(pd, className + "ServiceRs.java");
        if (filePath.exists()) {
            JavaClassSource javaClassOriginal = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)filePath);
            QueryableBuilder.addImportsToClass(javaClassOriginal, preQueryFilters, groupId);
            QueryableBuilder.addImportsToClass(javaClassOriginal, postQueryFilters, groupId);
            MethodSource<JavaClassSource> method = QueryableBuilder.getMethodByName(javaClassOriginal, "getSearch");
            if (method != null) {
                if (!QueryableBuilder.excludeMethodByName(javaClassOriginal, "getSearch")) {
                    method.setBody(templateMethod.getBody());
                } else {
                    log.info((CharSequence)String.format("getSearch in class %s is excluded from queryable plugin", className));
                }
            } else {
                javaClassOriginal.addMethod(templateMethod);
            }
            try (FileWriter out = new FileWriter(filePath);){
                out.append(javaClassOriginal.toString());
            }
        }
        pd.mkdirs();
        try (FileWriter out = new FileWriter(filePath);){
            out.append(javaClassTemplate.toString());
        }
    }

    private static void addImportsToClass(JavaClassSource javaClassSource, Collection<FilterDefBase> fd, String groupId) {
        if (fd == null) {
            return;
        }
        for (FilterDefBase f : fd) {
            if ("java.util.Date".equals(f.fieldType)) {
                javaClassSource.addImport("java.util.Date");
                javaClassSource.addImport(String.format("%s.api.util.DateUtils", groupId));
            }
            if ("LocalDateTime".equals(f.fieldType)) {
                javaClassSource.addImport("java.time.LocalDateTime");
            }
            if ("ZonedDateTime".equals(f.fieldType)) {
                javaClassSource.addImport("java.time.ZonedDateTime");
            }
            if ("LocalDate".equals(f.fieldType)) {
                javaClassSource.addImport("java.time.LocalDate");
            }
            if ("BigDecimal".equals(f.fieldType) || "big_decimal".equals(f.fieldType)) {
                javaClassSource.addImport("java.math.BigDecimal");
            }
            if ("BigInteger".equals(f.fieldType) || "big_integer".equals(f.fieldType)) {
                javaClassSource.addImport("java.math.BigInteger");
            }
            if (!(f instanceof QLikeListFilterDef)) continue;
            javaClassSource.addImport("java.util.HashMap");
            javaClassSource.addImport("java.util.Map");
        }
    }

    private static String getPathFromPackage(String packageName) {
        return packageName.replace(".", "/");
    }

    private static MethodSource<JavaClassSource> getMethodByName(JavaClassSource javaClassSource, String name) {
        for (MethodSource method : javaClassSource.getMethods()) {
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static boolean excludeMethodByName(JavaClassSource javaClassSource, String name) {
        for (MethodSource method : javaClassSource.getMethods()) {
            if (!name.equals(method.getName())) continue;
            List classAn = method.getAnnotations();
            for (AnnotationSource f : classAn) {
                if (!f.getName().startsWith("QExclude")) continue;
                return true;
            }
        }
        return false;
    }
}

