/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.builder;

import it.ness.queryable.model.QT;
import it.ness.queryable.model.pojo.Parameters;
import it.ness.queryable.model.pojo.TestDataPojo;
import it.ness.queryable.templates.FreeMarkerTemplates;
import it.ness.queryable.util.FileUtils;
import it.ness.queryable.util.ModelFiles;
import it.ness.queryable.util.StringUtil;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class TestBuilder {
    protected static String ANNOTATION_FIELD = QT.class.getSimpleName();
    protected static String ANNOTATION_ID = "Id";

    public static void generateSources(ModelFiles mf, Log log, Parameters parameters, String packageName) throws Exception {
        String[] modelFiles;
        for (String modelFileName : modelFiles = mf.getModelFileNames()) {
            int order = 1;
            StringBuilder sb = new StringBuilder();
            String className = StringUtil.getClassNameFromFileName(modelFileName);
            if (!mf.excludeClass(className).booleanValue()) {
                try {
                    TestDataPojo testDataPojo = TestBuilder.readModel(log, modelFileName, parameters);
                    String methods = TestBuilder.printValues(testDataPojo, className, order);
                    if (methods != null) {
                        sb.append(methods);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            String allMethods = sb.toString();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("packageName", packageName);
            List<String> created = TestBuilder.getCreated(log, modelFileName, mf);
            map.put("createdItems", created);
            map.put("allMethods", allMethods);
            String testClassName = className + "ServiceRsTest";
            map.put("testClassName", testClassName);
            File testfile = new File(parameters.testPath + "/");
            FileUtils.deleteJavaClassFromTemplate(testfile, "TestServiceRs", testClassName);
            FileUtils.createJavaClassFromTemplate(testfile, "TestServiceRs", testClassName, map, log);
        }
        if (log != null) {
            log.info((CharSequence)"Done generating sources");
        }
    }

    private static TestDataPojo readModel(Log log, String modelFileName, Parameters parameters) throws Exception {
        List list;
        String path = parameters.modelPath;
        JavaClassSource javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)new File(path, modelFileName));
        List fieldsList = javaClass.getFields();
        TestDataPojo testDataPojo = new TestDataPojo();
        for (AnnotationSource anno : javaClass.getAnnotations()) {
            if (!anno.getName().equals("QRs")) continue;
            testDataPojo.rsPath = anno.getStringValue();
        }
        testDataPojo.tFieldList = new ArrayList<QT>();
        ArrayList<FieldSource> defaultFields = new ArrayList<FieldSource>();
        for (FieldSource field : fieldsList) {
            list = field.getAnnotations();
            boolean addDefaults = true;
            for (AnnotationSource anno : list) {
                QT tField;
                if (anno.getName().equals(ANNOTATION_FIELD)) {
                    tField = new QT();
                    tField.defaultValue = anno.getStringValue("defaultValue");
                    tField.updatedValue = anno.getStringValue("updatedValue");
                    tField.field = field;
                    tField.annotations = list;
                    tField.isId = false;
                    testDataPojo.tFieldList.add(tField);
                    addDefaults = false;
                }
                if (!anno.getName().equals(ANNOTATION_ID)) continue;
                tField = new QT();
                tField.defaultValue = null;
                tField.updatedValue = null;
                tField.field = field;
                tField.annotations = list;
                tField.isId = true;
                testDataPojo.tFieldList.add(tField);
                addDefaults = false;
            }
            if (!addDefaults) continue;
            defaultFields.add(field);
        }
        for (FieldSource field : defaultFields) {
            QT tField = TestBuilder.getDefaultsField(log, (FieldSource<JavaClassSource>)field, list = field.getAnnotations());
            if (tField == null) continue;
            testDataPojo.tFieldList.add(tField);
        }
        return testDataPojo;
    }

    public static String printValues(TestDataPojo testDataPojo, String className, int order) {
        List<QT> tFieldList = testDataPojo.tFieldList;
        if (tFieldList.size() > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String classInstance = className.toLowerCase();
            map.put("className", className);
            map.put("classInstance", classInstance);
            map.put("rsPath", testDataPojo.rsPath);
            map.put("insertItems", TestBuilder.getInsertFields(tFieldList, className, classInstance));
            map.put("putItems", TestBuilder.getPutFields(tFieldList, className, classInstance));
            map.put("createdInstance", "created" + className);
            map.put("updatedInstance", "updated" + className);
            map.put("addMethod", "shouldAdd" + className + "Item");
            map.put("putMethod", "shouldPut" + className + "Item");
            map.put("deleteMethod", "shouldDelete" + className + "Item");
            map.put("addMethodOrder", order);
            map.put("putMethodOrder", order + 1);
            map.put("deleteMethodOrder", order + 2);
            for (QT tField : tFieldList) {
                if (!tField.isId) continue;
                map.put("id", tField.field.getName());
            }
            String serviceRsClass = FreeMarkerTemplates.processTemplate("TestShouldAdd", map);
            return serviceRsClass;
        }
        return null;
    }

    public static List<String> getCreated(Log log, String modelFileName, ModelFiles mf) {
        ArrayList<String> statements = new ArrayList<String>();
        String className = StringUtil.getClassNameFromFileName(modelFileName);
        if (!mf.excludeClass(className).booleanValue()) {
            try {
                statements.add(String.format("public static %s %s;", className, "created" + className));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return statements;
    }

    public static List<String> getInsertFields(List<QT> tFieldList, String className, String classInstance) {
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(String.format("%s %s = new %s();", className, classInstance, className));
        for (QT tField : tFieldList) {
            if (tField.isId) continue;
            if (tField.field.getType().getName().equals("String")) {
                statements.add(String.format("%s.%s = \"%s\";", classInstance, tField.field.getName(), tField.defaultValue));
            }
            if (tField.field.getType().getName().equalsIgnoreCase("int") || tField.field.getType().getName().equalsIgnoreCase("integer") || tField.field.getType().getName().equalsIgnoreCase("long") || tField.field.getType().getName().equalsIgnoreCase("boolean")) {
                statements.add(String.format("%s.%s = %s;", classInstance, tField.field.getName(), tField.defaultValue));
            }
            if (tField.field.getType().getName().equals("LocalDateTime")) {
                statements.add(String.format("%s.%s = LocalDateTime.parse(\"%s\");", classInstance, tField.field.getName(), tField.defaultValue));
            }
            if (tField.field.getType().getName().equals("BigDecimal")) {
                statements.add(String.format("%s.%s = BigDecimal.valueOf(%s);", classInstance, tField.field.getName(), tField.defaultValue));
            }
            if (!tField.field.getType().getName().equals("BigInteger")) continue;
            statements.add(String.format("%s.%s = BigInteger.valueOf(%s);", classInstance, tField.field.getName(), tField.defaultValue));
        }
        return statements;
    }

    public static List<String> getPutFields(List<QT> tFieldList, String className, String classInstance) {
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(String.format("%s %s = created%s;", className, classInstance, className));
        for (QT tField : tFieldList) {
            if (tField.isId) continue;
            if (tField.field.getType().getName().equals("String")) {
                statements.add(String.format("%s.%s = \"%s\";", classInstance, tField.field.getName(), tField.updatedValue));
            }
            if (tField.field.getType().getName().equalsIgnoreCase("int") || tField.field.getType().getName().equalsIgnoreCase("integer") || tField.field.getType().getName().equalsIgnoreCase("long") || tField.field.getType().getName().equalsIgnoreCase("boolean")) {
                statements.add(String.format("%s.%s = %s;", classInstance, tField.field.getName(), tField.updatedValue));
            }
            if (tField.field.getType().getName().equals("LocalDateTime")) {
                statements.add(String.format("%s.%s = LocalDateTime.parse(\"%s\");", classInstance, tField.field.getName(), tField.updatedValue));
            }
            if (tField.field.getType().getName().equals("BigDecimal")) {
                statements.add(String.format("%s.%s = BigDecimal.valueOf(%s);", classInstance, tField.field.getName(), tField.defaultValue));
            }
            if (!tField.field.getType().getName().equals("BigInteger")) continue;
            statements.add(String.format("%s.%s = BigInteger.valueOf(%s);", classInstance, tField.field.getName(), tField.defaultValue));
        }
        return statements;
    }

    public static QT getDefaultsField(Log log, FieldSource<JavaClassSource> field, List<AnnotationSource<JavaClassSource>> list) {
        QT tField;
        boolean isId = false;
        for (AnnotationSource<JavaClassSource> anno : list) {
            if (!anno.getName().equals(ANNOTATION_ID)) continue;
            isId = true;
        }
        if (field.getType().getName().equals("String")) {
            tField = new QT();
            tField.defaultValue = "defaultValue_" + field.getName();
            tField.updatedValue = "updatedValue_" + field.getName();
            tField.field = field;
            tField.annotations = list;
            tField.isId = isId;
            return tField;
        }
        if (field.getType().getName().equals("int") || field.getType().getName().equals("Integer") || field.getType().getName().equals("long") || field.getType().getName().equals("Long")) {
            tField = new QT();
            tField.defaultValue = "0";
            tField.updatedValue = "1";
            tField.field = field;
            tField.annotations = list;
            tField.isId = isId;
            return tField;
        }
        if (field.getType().getName().equals("boolean") || field.getType().getName().equals("Boolean")) {
            tField = new QT();
            tField.defaultValue = "false";
            tField.updatedValue = "true";
            tField.field = field;
            tField.annotations = list;
            tField.isId = isId;
            return tField;
        }
        if (field.getType().getName().equals("LocalDateTime")) {
            tField = new QT();
            tField.defaultValue = LocalDateTime.now().toString();
            tField.updatedValue = LocalDateTime.now().plusDays(1L).toString();
            tField.field = field;
            tField.annotations = list;
            tField.isId = isId;
            return tField;
        }
        if (field.getType().getName().equals("LocalDate")) {
            tField = new QT();
            tField.defaultValue = LocalDate.now().toString();
            tField.updatedValue = LocalDate.now().plusDays(1L).toString();
            tField.field = field;
            tField.annotations = list;
            tField.isId = isId;
            return tField;
        }
        if (field.getType().getName().equals("BigDecimal")) {
            tField = new QT();
            tField.defaultValue = "0";
            tField.updatedValue = "1";
            tField.field = field;
            tField.annotations = list;
            tField.isId = isId;
            return tField;
        }
        if (field.getType().getName().equals("BigInteger")) {
            tField = new QT();
            tField.defaultValue = "0";
            tField.updatedValue = "1";
            tField.field = field;
            tField.annotations = list;
            tField.isId = isId;
            return tField;
        }
        if (log != null) {
            log.warn((CharSequence)("Unknown field type :" + field.getType().getName()));
        }
        return null;
    }
}

