/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.model;

import it.ness.queryable.annotations.QOption;
import it.ness.queryable.model.enums.FilterType;
import it.ness.queryable.util.StringUtil;
import java.util.List;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public abstract class FilterDefBase
implements Comparable<FilterDefBase> {
    protected Log log;
    protected StringUtil stringUtil;
    public String entityName;
    public String prefix;
    public String name;
    public String type;
    public String fieldType;
    public String condition;
    public String filterName;
    public String queryName;
    public QOption[] options;

    public abstract void addAnnotationToModelClass(JavaClassSource var1);

    public abstract FilterDefBase parseQFilterDef(String var1, FieldSource<JavaClassSource> var2, boolean var3);

    public abstract String getSearchMethod();

    public abstract FilterType getFilterType();

    public abstract boolean overrideOnSameFilterName();

    public FilterDefBase(Log log) {
        this.log = log;
    }

    public boolean containsOption(QOption qOption) {
        if (this.options == null) {
            return false;
        }
        for (QOption o : this.options) {
            if (!o.equals((Object)qOption)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterDefBase filterDef = (FilterDefBase)o;
        return this.filterName.equals(filterDef.filterName);
    }

    public int hashCode() {
        return Objects.hash(this.filterName);
    }

    public String toString() {
        return String.format("FilterDef={entityName=%s, prefix=%s, name=%s, type=%s, condition=%s}", this.entityName, this.prefix, this.name, this.type, this.condition);
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public int compareTo(FilterDefBase filterDef) {
        if (this.getFilterType().equals((Object)filterDef.getFilterType())) {
            return this.filterName.compareTo(filterDef.filterName);
        }
        return this.getFilterType().compareTo(filterDef.getFilterType());
    }

    protected void removeFilterDef(JavaClassSource javaClass, String filterName) {
        List classAn = javaClass.getAnnotations();
        for (AnnotationSource f : classAn) {
            String name;
            if (!f.getName().startsWith("FilterDef") && !f.getName().startsWith("Filter") || (name = f.getLiteralValue("name")) == null || !(name = StringUtil.removeQuotes(name)).equals(filterName)) continue;
            javaClass.removeAnnotation((Annotation)f);
        }
    }

    protected String getQAnnotationValue(AnnotationSource<JavaClassSource> a, String fieldName, String defaultValue) {
        if (a == null || fieldName == null) {
            return defaultValue;
        }
        String value = a.getLiteralValue(fieldName);
        value = null == value ? defaultValue : StringUtil.removeQuotes(value);
        return value;
    }
}

