/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.model;

import it.ness.queryable.annotations.QOption;
import it.ness.queryable.model.FilterDefBase;
import it.ness.queryable.model.enums.FilterType;
import it.ness.queryable.util.FilterUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class QFilterDef
extends FilterDefBase {
    protected static String ANNOTATION_NAME = "Q";
    protected static String PREFIX = "obj";

    public QFilterDef(Log log) {
        super(log);
    }

    @Override
    public void addAnnotationToModelClass(JavaClassSource javaClass) {
        if ("LocalDateTime".equals(this.fieldType) || "LocalDate".equals(this.fieldType) || "ZonedDateTime".equals(this.fieldType) || "java.util.Date".equals(this.fieldType)) {
            this.addAnnotationToModelClass_date(javaClass);
            return;
        }
        this.addAnnotationToModelClass_obj(javaClass);
    }

    public void addAnnotationToModelClass_obj(JavaClassSource javaClass) {
        this.removeFilterDef(javaClass, this.filterName);
        AnnotationSource<JavaClassSource> filterDefAnnotation = FilterUtils.addFilterDef(javaClass, this.filterName);
        FilterUtils.addParamDef(filterDefAnnotation, this.name, this.type);
        FilterUtils.addFilter(javaClass, this.filterName, String.format("%s = :%s", this.name, this.name));
    }

    public void addAnnotationToModelClass_date(JavaClassSource javaClass) {
        String filterNameFrom = this.entityName + ".from." + this.name;
        String filterNameTo = this.entityName + ".to." + this.name;
        String filterNameObj = this.entityName + ".obj." + this.name;
        this.removeFilterDef(javaClass, filterNameFrom);
        this.removeFilterDef(javaClass, filterNameTo);
        this.removeFilterDef(javaClass, filterNameObj);
        AnnotationSource<JavaClassSource> filterDefAnnotationObj = FilterUtils.addFilterDef(javaClass, filterNameObj);
        FilterUtils.addParamDef(filterDefAnnotationObj, this.name, this.type);
        FilterUtils.addFilter(javaClass, filterNameObj, String.format("%s = :%s", this.name, this.name));
        AnnotationSource<JavaClassSource> filterDefAnnotationFrom = FilterUtils.addFilterDef(javaClass, filterNameFrom);
        FilterUtils.addParamDef(filterDefAnnotationFrom, this.name, this.type);
        FilterUtils.addFilter(javaClass, filterNameFrom, String.format("%s >= :%s", this.name, this.name));
        AnnotationSource<JavaClassSource> filterDefAnnotationTo = FilterUtils.addFilterDef(javaClass, filterNameTo);
        FilterUtils.addParamDef(filterDefAnnotationTo, this.name, this.type);
        FilterUtils.addFilter(javaClass, filterNameTo, String.format("%s <= :%s", this.name, this.name));
    }

    @Override
    public QFilterDef parseQFilterDef(String entityName, FieldSource<JavaClassSource> f, boolean qClassLevelAnnotation) {
        Set<String> supportedTypes;
        AnnotationSource a = f.getAnnotation(ANNOTATION_NAME);
        if (null == a && !qClassLevelAnnotation) {
            return null;
        }
        String prefix = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "prefix", PREFIX);
        String name = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "name", f.getName());
        String condition = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "condition", null);
        String options = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "options", null);
        String fieldType = f.getType().getName();
        if (f.getAnnotation("Enumerated") != null) {
            fieldType = "String";
        }
        if (!(supportedTypes = this.getSupportedTypes()).contains(fieldType)) {
            this.log.error((CharSequence)String.format("%s is not applicable for fieldType: %s fieldName: %s", ANNOTATION_NAME, fieldType, name));
            return null;
        }
        QFilterDef fd = new QFilterDef(this.log);
        fd.entityName = entityName;
        fd.prefix = prefix;
        fd.name = name;
        fd.fieldType = this.getTypeFromFieldType(fieldType);
        fd.type = this.getTypeFromFieldType(fieldType);
        fd.filterName = entityName + "." + prefix + "." + name;
        fd.queryName = prefix + "." + name;
        fd.condition = condition;
        if (null != options) {
            fd.options = QOption.from(options);
        }
        return fd;
    }

    private String getStringSearchMethod() {
        if (null == this.condition) {
            String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\", Parameters.with(\"%s\", get(\"%s\")));}";
            return String.format(formatBody, this.queryName, this.filterName, this.name, this.queryName);
        }
        String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\", Parameters.with(\"%s\", \"%s\"));}";
        return String.format(formatBody, this.queryName, this.filterName, this.name, this.condition);
    }

    private String getIntegerSearchMethod() {
        String formatBody = "if (nn(\"%s\")) {Integer numberof = _integer(\"%s\");search.filter(\"%s\", Parameters.with(\"%s\", numberof));}";
        return String.format(formatBody, this.queryName, this.queryName, this.filterName, this.name);
    }

    private String getLongSearchMethod() {
        String formatBody = "if (nn(\"%s\")) {Long numberof = _long(\"%s\");search.filter(\"%s\", Parameters.with(\"%s\", numberof));}";
        return String.format(formatBody, this.queryName, this.queryName, this.filterName, this.name);
    }

    private String getBooleanSearchMethod() {
        if (null == this.condition) {
            String formatBody = "if (nn(\"%s\")) {Boolean valueof = _boolean(\"%s\");search.filter(\"%s\", Parameters.with(\"%s\", valueof));}";
            return String.format(formatBody, this.queryName, this.queryName, this.filterName, this.name);
        }
        String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\", Parameters.with(\"%s\", %s));}";
        return String.format(formatBody, this.queryName, this.queryName, this.filterName, this.condition);
    }

    private String getBigDecimalSearchMethod() {
        String formatBody = "if (nn(\"%s\")) {BigDecimal numberof = new BigDecimal(get(\"%s\"));search.filter(\"%s\", Parameters.with(\"%s\", numberof));}";
        return String.format(formatBody, this.queryName, this.queryName, this.filterName, this.name);
    }

    private String getBigIntegerSearchMethod() {
        String formatBody = "if (nn(\"%s\")) {BigInteger numberof = new BigInteger(get(\"%s\"));search.filter(\"%s\", Parameters.with(\"%s\", numberof));}";
        return String.format(formatBody, this.queryName, this.queryName, this.filterName, this.name);
    }

    private String getLocalDateSearchMethod() {
        StringBuilder sb = new StringBuilder();
        String formatBody = "if (nn(\"%s\")) {LocalDate date = LocalDate.parse(get(\"%s\"));search.filter(\"%s\", Parameters.with(\"%s\", date));}";
        String filterName = this.entityName + ".from." + this.name;
        String queryName = "from." + this.name;
        sb.append(String.format(formatBody, queryName, queryName, filterName, this.name));
        filterName = this.entityName + ".to." + this.name;
        queryName = "to." + this.name;
        sb.append(String.format(formatBody, queryName, queryName, filterName, this.name));
        filterName = this.entityName + ".obj." + this.name;
        queryName = "obj." + this.name;
        sb.append(String.format(formatBody, queryName, queryName, filterName, this.name));
        return sb.toString();
    }

    private String getLocalDateTimeSearchMethod() {
        StringBuilder sb = new StringBuilder();
        String formatBody = "if (nn(\"%s\")) {LocalDateTime date = LocalDateTime.parse(get(\"%s\"));search.filter(\"%s\", Parameters.with(\"%s\", date));}";
        String filterName = this.entityName + ".from." + this.name;
        String queryName = "from." + this.name;
        sb.append(String.format(formatBody, queryName, queryName, filterName, this.name));
        filterName = this.entityName + ".to." + this.name;
        queryName = "to." + this.name;
        sb.append(String.format(formatBody, queryName, queryName, filterName, this.name));
        filterName = this.entityName + ".obj." + this.name;
        queryName = "obj." + this.name;
        sb.append(String.format(formatBody, queryName, queryName, filterName, this.name));
        return sb.toString();
    }

    private String getZonedDateTimeSearchMethod() {
        StringBuilder sb = new StringBuilder();
        String formatBody = "if (nn(\"%s\")) {ZonedDateTime date = ZonedDateTime.parse(get(\"%s\"));search.filter(\"%s\", Parameters.with(\"%s\", date));}";
        String filterName = this.entityName + ".from." + this.name;
        String queryName = "from." + this.name;
        sb.append(String.format(formatBody, queryName, queryName, filterName, this.name));
        filterName = this.entityName + ".to." + this.name;
        queryName = "to." + this.name;
        sb.append(String.format(formatBody, queryName, queryName, filterName, this.name));
        filterName = this.entityName + ".obj." + this.name;
        queryName = "obj." + this.name;
        sb.append(String.format(formatBody, queryName, queryName, filterName, this.name));
        return sb.toString();
    }

    private String getDateSearchMethod() {
        StringBuilder sb = new StringBuilder();
        String formatBody = "if (nn(\"%s\")) {Date date = DateUtils.parseDate(get(\"%s\"));search.filter(\"%s\", Parameters.with(\"%s\", date));}";
        String filterName = this.entityName + ".from." + this.name;
        this.queryName = "from." + this.name;
        sb.append(String.format(formatBody, this.queryName, this.queryName, filterName, this.name));
        filterName = this.entityName + ".to." + this.name;
        this.queryName = "to." + this.name;
        sb.append(String.format(formatBody, this.queryName, this.queryName, filterName, this.name));
        filterName = this.entityName + ".obj." + this.name;
        this.queryName = "obj." + this.name;
        sb.append(String.format(formatBody, this.queryName, this.queryName, filterName, this.name));
        return sb.toString();
    }

    @Override
    public String getSearchMethod() {
        if (this.containsOption(QOption.EXECUTE_ALWAYS)) {
            switch (this.fieldType) {
                case "boolean": {
                    return this.getBooleanEqualsAlways();
                }
            }
            return this.getStringEqualsAlways();
        }
        if (this.containsOption(QOption.WITHOUT_PARAMETERS)) {
            switch (this.fieldType) {
                case "boolean": {
                    return this.getBooleanEqualsWithoutParameters();
                }
            }
            return this.getStringEqualsWithoutParameters();
        }
        switch (this.fieldType) {
            case "string": {
                return this.getStringSearchMethod();
            }
            case "LocalDateTime": {
                return this.getLocalDateTimeSearchMethod();
            }
            case "ZonedDateTime": {
                return this.getZonedDateTimeSearchMethod();
            }
            case "LocalDate": {
                return this.getLocalDateSearchMethod();
            }
            case "java.util.Date": {
                return this.getDateSearchMethod();
            }
            case "boolean": {
                return this.getBooleanSearchMethod();
            }
            case "big_decimal": {
                return this.getBigDecimalSearchMethod();
            }
            case "big_integer": {
                return this.getBigIntegerSearchMethod();
            }
            case "int": {
                return this.getIntegerSearchMethod();
            }
            case "long": {
                return this.getLongSearchMethod();
            }
        }
        this.log.error((CharSequence)("not handled getSearchMethod for fieldType: " + this.fieldType + " name: " + this.name));
        return "";
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.POSTQUERY;
    }

    @Override
    public boolean overrideOnSameFilterName() {
        return true;
    }

    private String getStringEqualsAlways() {
        if (null == this.condition) {
            String formatBody = "search.filter(\"%s\", Parameters.with(\"%s\", get(\"%s\")));";
            return String.format(formatBody, this.filterName, this.name, this.queryName);
        }
        String formatBody = "search.filter(\"%s\", Parameters.with(\"%s\", \"%s\"));";
        return String.format(formatBody, this.filterName, this.name, this.condition);
    }

    private String getStringEqualsWithoutParameters() {
        String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\");}";
        return String.format(formatBody, this.queryName, this.filterName);
    }

    private String getBooleanEqualsAlways() {
        if (null == this.condition) {
            String formatBody = "search.filter(\"%s\", Parameters.with(\"%s\", get(\"%s\")));";
            return String.format(formatBody, this.filterName, this.name, this.queryName);
        }
        String formatBody = "search.filter(\"%s\", Parameters.with(\"%s\", %s));";
        return String.format(formatBody, this.filterName, this.name, this.condition);
    }

    private String getBooleanEqualsWithoutParameters() {
        String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\");}";
        return String.format(formatBody, this.queryName, this.filterName);
    }

    private String getTypeFromFieldType(String fieldType) {
        switch (fieldType) {
            case "String": {
                return "string";
            }
            case "LocalDateTime": {
                return "LocalDateTime";
            }
            case "ZonedDateTime": {
                return "ZonedDateTime";
            }
            case "LocalDate": {
                return "LocalDate";
            }
            case "Date": {
                return "java.util.Date";
            }
            case "Boolean": 
            case "boolean": {
                return "boolean";
            }
            case "BigDecimal": {
                return "big_decimal";
            }
            case "BigInteger": {
                return "big_integer";
            }
            case "Integer": 
            case "int": {
                return "int";
            }
            case "Long": 
            case "long": {
                return "long";
            }
        }
        this.log.error((CharSequence)("unknown getTypeFromFieldType from :" + fieldType));
        return null;
    }

    private Set<String> getSupportedTypes() {
        HashSet<String> supported = new HashSet<String>();
        supported.add("String");
        supported.add("Integer");
        supported.add("int");
        supported.add("Long");
        supported.add("long");
        supported.add("Boolean");
        supported.add("boolean");
        supported.add("BigDecimal");
        supported.add("BigInteger");
        supported.add("LocalDateTime");
        supported.add("ZonedDateTime");
        supported.add("LocalDate");
        supported.add("Date");
        return supported;
    }
}

