/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.model;

import it.ness.queryable.annotations.QOption;
import it.ness.queryable.model.FilterDefBase;
import it.ness.queryable.model.enums.FilterType;
import it.ness.queryable.util.FilterUtils;
import it.ness.queryable.util.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class QLikeListFilterDef
extends FilterDefBase {
    protected static String ANNOTATION_NAME = "QLikeList";
    protected static String PREFIX = "like";
    protected String nameInPlural;

    public QLikeListFilterDef(Log log) {
        super(log);
    }

    @Override
    public void addAnnotationToModelClass(JavaClassSource javaClass) {
        this.nameInPlural = null;
        if (this.name.contains("_")) {
            this.nameInPlural = StringUtil.getPlural(this.name.substring(this.name.indexOf("_") + 1));
            this.nameInPlural = this.name.substring(0, this.name.indexOf("_") + 1) + this.nameInPlural;
        } else {
            this.nameInPlural = StringUtil.getPlural(this.name);
        }
        this.filterName = this.entityName + "." + this.prefix + "." + this.nameInPlural;
        this.queryName = this.prefix + "." + this.nameInPlural;
        this.removeFilterDef(javaClass, this.filterName);
        AnnotationSource<JavaClassSource> filterDefAnnotation = FilterUtils.addFilterDef(javaClass, this.filterName);
        FilterUtils.addParamDef(filterDefAnnotation, this.nameInPlural, "string");
        if (null == this.condition) {
            FilterUtils.addFilter(javaClass, this.filterName, String.format("lower(%s) LIKE :%s", this.nameInPlural, this.nameInPlural));
        } else {
            FilterUtils.addFilter(javaClass, this.filterName, this.condition);
        }
    }

    @Override
    public QLikeListFilterDef parseQFilterDef(String entityName, FieldSource<JavaClassSource> f, boolean qClassLevelAnnotation) {
        AnnotationSource a = f.getAnnotation(ANNOTATION_NAME);
        if (null == a) {
            return null;
        }
        String prefix = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "prefix", PREFIX);
        String name = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "name", f.getName());
        String condition = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "condition", null);
        String options = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "options", null);
        String fieldType = f.getType().getName();
        Set<String> supportedTypes = this.getSupportedTypes();
        if (!supportedTypes.contains(fieldType)) {
            this.log.error((CharSequence)String.format("%s is not applicable for fieldType: %s fieldName: %s", ANNOTATION_NAME, fieldType, name));
            return null;
        }
        QLikeListFilterDef fd = new QLikeListFilterDef(this.log);
        fd.entityName = entityName;
        fd.prefix = prefix;
        fd.name = name;
        fd.fieldType = this.getTypeFromFieldType(fieldType);
        fd.type = this.getTypeFromFieldType(fieldType);
        fd.filterName = entityName + "." + prefix + "." + name;
        fd.queryName = prefix + "." + name;
        fd.condition = condition;
        if (null != options) {
            fd.options = QOption.from(options);
        }
        return fd;
    }

    @Override
    public String getSearchMethod() {
        String formatBody = "if (nn(\"%s\")) {   String[] %s = get(\"%s\").split(\",\");   StringBuilder sb = new StringBuilder();   if (null == params) {      params = new HashMap<>();   }   for (int i = 0; i < %s.length; i++) {      final String paramName = String.format(\"%s%%d\", i);      sb.append(String.format(\"%s LIKE :%%s\", paramName));      params.put(paramName, %s + %s[i] + %s);      if (i < %s.length - 1) {         sb.append(\" OR \");      }   }   if (null == query) {      query = sb.toString();   }   else {      query = query + \" OR \" + sb.toString();\n   }}";
        return String.format(formatBody, this.queryName, this.nameInPlural, this.queryName, this.nameInPlural, this.name, this.name, "\"%\"", this.nameInPlural, "\"%\"", this.nameInPlural);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.PREQUERY;
    }

    @Override
    public boolean overrideOnSameFilterName() {
        return true;
    }

    private String getTypeFromFieldType(String fieldType) {
        switch (fieldType) {
            case "String": {
                return "string";
            }
        }
        this.log.error((CharSequence)("unknown getTypeFromFieldType from :" + fieldType));
        return null;
    }

    private Set<String> getSupportedTypes() {
        HashSet<String> supported = new HashSet<String>();
        supported.add("String");
        return supported;
    }
}

