/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.model;

import it.ness.queryable.annotations.QOption;
import it.ness.queryable.model.FilterDefBase;
import it.ness.queryable.model.enums.FilterType;
import it.ness.queryable.util.FilterUtils;
import it.ness.queryable.util.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class QListFilterDef
extends FilterDefBase {
    protected static String ANNOTATION_NAME = "QList";
    protected static String PREFIX = "obj";
    protected String nameInPlural;

    public QListFilterDef(Log log) {
        super(log);
    }

    @Override
    public void addAnnotationToModelClass(JavaClassSource javaClass) {
        this.nameInPlural = null;
        if (this.name.contains("_")) {
            this.nameInPlural = StringUtil.getPlural(this.name.substring(this.name.indexOf("_") + 1));
            this.nameInPlural = this.name.substring(0, this.name.indexOf("_") + 1) + this.nameInPlural;
        } else {
            this.nameInPlural = StringUtil.getPlural(this.name);
        }
        this.filterName = this.entityName + "." + this.prefix + "." + this.nameInPlural;
        this.queryName = this.prefix + "." + this.nameInPlural;
        this.removeFilterDef(javaClass, this.filterName);
        AnnotationSource<JavaClassSource> filterDefAnnotation = FilterUtils.addFilterDef(javaClass, this.filterName);
        FilterUtils.addParamDef(filterDefAnnotation, this.nameInPlural, "string");
        if (null == this.condition) {
            FilterUtils.addFilter(javaClass, this.filterName, String.format("%s IN (:%s)", this.name, this.nameInPlural));
        } else {
            FilterUtils.addFilter(javaClass, this.filterName, this.condition);
        }
    }

    @Override
    public QListFilterDef parseQFilterDef(String entityName, FieldSource<JavaClassSource> f, boolean qClassLevelAnnotation) {
        AnnotationSource a = f.getAnnotation(ANNOTATION_NAME);
        if (null == a) {
            return null;
        }
        String prefix = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "prefix", PREFIX);
        String name = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "name", f.getName());
        String condition = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "condition", null);
        String options = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "options", null);
        String fieldType = f.getType().getName();
        Set<String> supportedTypes = this.getSupportedTypes();
        if (!supportedTypes.contains(fieldType)) {
            this.log.error((CharSequence)String.format("%s is not applicable for fieldType: %s fieldName: %s", ANNOTATION_NAME, fieldType, name));
            return null;
        }
        QListFilterDef fd = new QListFilterDef(this.log);
        fd.entityName = entityName;
        fd.prefix = prefix;
        fd.name = name;
        fd.fieldType = this.getTypeFromFieldType(fieldType);
        fd.type = this.getTypeFromFieldType(fieldType);
        fd.filterName = entityName + "." + prefix + "." + name;
        fd.queryName = prefix + "." + name;
        fd.condition = condition;
        if (null != options) {
            fd.options = QOption.from(options);
        }
        return fd;
    }

    @Override
    public String getSearchMethod() {
        switch (this.fieldType) {
            case "string": {
                return this.getStringSearchMethod();
            }
            case "integer": {
                return this.getIntegerSearchMethod();
            }
            case "long": {
                return this.getLongSearchMethod();
            }
        }
        this.log.error((CharSequence)("not handled getSearchMethod for fieldType: " + this.fieldType + " name: " + this.name));
        return "";
    }

    private String getStringSearchMethod() {
        if (null == this.condition) {
            String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\", Parameters.with(\"%s\", asList(\"%s\")));}";
            return String.format(formatBody, this.queryName, this.filterName, this.nameInPlural, this.queryName);
        }
        String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\", Parameters.with(\"%s\", \"%s\"));}";
        return String.format(formatBody, this.queryName, this.filterName, this.nameInPlural, this.condition);
    }

    private String getLongSearchMethod() {
        if (null == this.condition) {
            String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\", Parameters.with(\"%s\", asLongList(\"%s\")));}";
            return String.format(formatBody, this.queryName, this.filterName, this.nameInPlural, this.queryName);
        }
        String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\", Parameters.with(\"%s\", \"%s\"));}";
        return String.format(formatBody, this.queryName, this.filterName, this.nameInPlural, this.condition);
    }

    private String getIntegerSearchMethod() {
        if (null == this.condition) {
            String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\", Parameters.with(\"%s\", asIntegerList(\"%s\")));}";
            return String.format(formatBody, this.queryName, this.filterName, this.nameInPlural, this.queryName);
        }
        String formatBody = "if (nn(\"%s\")) {search.filter(\"%s\", Parameters.with(\"%s\", \"%s\"));}";
        return String.format(formatBody, this.queryName, this.filterName, this.nameInPlural, this.condition);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.POSTQUERY;
    }

    @Override
    public boolean overrideOnSameFilterName() {
        return true;
    }

    private String getTypeFromFieldType(String fieldType) {
        switch (fieldType) {
            case "String": {
                return "string";
            }
            case "Integer": {
                return "int";
            }
            case "Long": {
                return "long";
            }
        }
        this.log.error((CharSequence)("unknown getTypeFromFieldType from :" + fieldType));
        return null;
    }

    private Set<String> getSupportedTypes() {
        HashSet<String> supported = new HashSet<String>();
        supported.add("String");
        supported.add("Integer");
        supported.add("Long");
        return supported;
    }
}

