/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.model;

import it.ness.queryable.annotations.QOption;
import it.ness.queryable.model.FilterDefBase;
import it.ness.queryable.model.enums.FilterType;
import it.ness.queryable.util.FilterUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class QLogicalDeleteFilterDef
extends FilterDefBase {
    protected static String ANNOTATION_NAME = "QLogicalDelete";
    protected static String PREFIX = "obj";

    public QLogicalDeleteFilterDef(Log log) {
        super(log);
    }

    @Override
    public void addAnnotationToModelClass(JavaClassSource javaClass) {
        this.removeFilterDef(javaClass, this.filterName);
        AnnotationSource<JavaClassSource> filterDefAnnotation = FilterUtils.addFilterDef(javaClass, this.filterName);
        FilterUtils.addParamDef(filterDefAnnotation, this.name, this.type);
        FilterUtils.addFilter(javaClass, this.filterName, String.format("%s = :%s", this.name, this.name));
    }

    @Override
    public QLogicalDeleteFilterDef parseQFilterDef(String entityName, FieldSource<JavaClassSource> f, boolean qClassLevelAnnotation) {
        AnnotationSource a = f.getAnnotation(ANNOTATION_NAME);
        if (null == a) {
            return null;
        }
        String prefix = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "prefix", PREFIX);
        String name = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "name", f.getName());
        String condition = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "condition", null);
        String options = this.getQAnnotationValue((AnnotationSource<JavaClassSource>)a, "options", null);
        String fieldType = f.getType().getName();
        Set<String> supportedTypes = this.getSupportedTypes();
        if (!supportedTypes.contains(fieldType)) {
            this.log.error((CharSequence)String.format("%s is not applicable for fieldType: %s fieldName: %s", ANNOTATION_NAME, fieldType, name));
            return null;
        }
        QLogicalDeleteFilterDef fd = new QLogicalDeleteFilterDef(this.log);
        fd.entityName = entityName;
        fd.prefix = prefix;
        fd.name = name;
        fd.fieldType = this.getTypeFromFieldType(fieldType);
        fd.type = this.getTypeFromFieldType(fieldType);
        fd.filterName = entityName + "." + prefix + "." + name;
        fd.queryName = prefix + "." + name;
        fd.condition = condition;
        if (null != options) {
            fd.options = QOption.from(options);
        }
        return fd;
    }

    @Override
    public String getSearchMethod() {
        String formatBody = "if (nn(\"%s\")) {Boolean valueof = _boolean(\"%s\");search.filter(\"%s\", Parameters.with(\"%s\", valueof));} else {search.filter(\"%s\", Parameters.with(\"%s\", true));}";
        return String.format(formatBody, this.queryName, this.queryName, this.filterName, this.name, this.filterName, this.name);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.POSTQUERY;
    }

    @Override
    public boolean overrideOnSameFilterName() {
        return true;
    }

    private String getTypeFromFieldType(String fieldType) {
        switch (fieldType) {
            case "boolean": {
                return "boolean";
            }
        }
        this.log.error((CharSequence)("unknown getTypeFromFieldType from :" + fieldType));
        return null;
    }

    private Set<String> getSupportedTypes() {
        HashSet<String> supported = new HashSet<String>();
        supported.add("boolean");
        return supported;
    }
}

