/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.templates;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FreeMarkerTemplates {
    public static Template getTemplate(String templateFileName, String templateName) throws IOException {
        InputStream inputStream = FreeMarkerTemplates.class.getResourceAsStream(templateFileName);
        String templateText = ((Stream)new BufferedReader(new InputStreamReader(inputStream)).lines().parallel()).collect(Collectors.joining("\n"));
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_30);
        StringTemplateLoader tloader = new StringTemplateLoader();
        cfg.setTemplateLoader((TemplateLoader)tloader);
        tloader.putTemplate(templateName, templateText);
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.VERSION_2_3_30));
        Template temp = cfg.getTemplate(templateName);
        return temp;
    }

    public static String processTemplate(String templateName, Map<String, Object> data) {
        try {
            Template temp = FreeMarkerTemplates.getTemplate(String.format("/templates/%s.ftl", templateName), templateName);
            StringWriter writer = new StringWriter();
            temp.process(data, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

