/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.util;

import it.ness.queryable.templates.FreeMarkerTemplates;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class FileUtils {
    public static File createPath(File dir, String spath, Log log) {
        File path = new File(dir, spath);
        if (!path.exists()) {
            if (log != null) {
                log.info((CharSequence)("Creating path: " + spath));
            }
            path.mkdirs();
        }
        return path;
    }

    public static void createJavaClassFromTemplate(File dir, String templateName, String replaceWithName, Map<String, Object> data, Log log) {
        String apiClass = FreeMarkerTemplates.processTemplate(templateName, data);
        File filePath = replaceWithName != null ? new File(dir, replaceWithName + ".java") : new File(dir, templateName + ".java");
        if (!filePath.exists()) {
            try (FileWriter out = new FileWriter(filePath);){
                if (log != null) {
                    log.info((CharSequence)("writing file " + filePath.getPath()));
                }
                out.append(apiClass);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (log != null) {
            log.info((CharSequence)("file: " + filePath.getPath() + " already exists."));
        }
    }

    public static void deleteJavaClassFromTemplate(File dir, String templateName, String replaceWithName) {
        File filePath = replaceWithName != null ? new File(dir, replaceWithName + ".java") : new File(dir, templateName + ".java");
        if (filePath.exists()) {
            filePath.delete();
        }
    }
}

