/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.util;

import it.ness.queryable.model.FilterDefBase;
import java.util.Collection;
import org.apache.maven.plugin.logging.Log;

public class GetSearchMethod {
    protected Log log;
    protected Collection<FilterDefBase> preQueryFilters;
    protected Collection<FilterDefBase> postQueryFilters;
    protected String className;

    public GetSearchMethod(Log log, Collection<FilterDefBase> preQueryFilters, Collection<FilterDefBase> postQueryFilters, String className) {
        this.log = log;
        this.preQueryFilters = preQueryFilters;
        this.postQueryFilters = postQueryFilters;
        this.className = className;
    }

    private String getQuery(String className, boolean existsPreQueryFilters) {
        if (!existsPreQueryFilters) {
            String formatBody = "PanacheQuery<%s> search; Sort sort = sort(orderBy);if (sort != null) {search = %s.find(null, sort);} else {search = %s.find(null);}";
            return String.format(formatBody, className, className, className);
        }
        String formatBody = "PanacheQuery<%s> search; Sort sort = sort(orderBy);if (sort != null) {search = %s.find(query, sort, params);} else {search = %s.find(query, params);}";
        return String.format(formatBody, className, className, className);
    }

    private String getPreQuery(boolean existsPreQueryFilters) {
        if (existsPreQueryFilters) {
            return "String query = null;Map<String, Object> params = null;";
        }
        return "";
    }

    public String create() {
        StringBuilder sb = new StringBuilder();
        boolean existsPreQueryFilters = this.preQueryFilters != null && this.preQueryFilters.size() > 0;
        boolean existsPostQueryFilters = this.postQueryFilters != null && this.postQueryFilters.size() > 0;
        sb.append(this.getPreQuery(existsPreQueryFilters));
        if (existsPreQueryFilters) {
            for (FilterDefBase f : this.preQueryFilters) {
                sb.append(f.getSearchMethod());
            }
        }
        sb.append(this.getQuery(this.className, existsPreQueryFilters));
        if (existsPostQueryFilters) {
            for (FilterDefBase f : this.postQueryFilters) {
                sb.append(f.getSearchMethod());
            }
        }
        sb.append("return search;");
        return sb.toString();
    }
}

