/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.util;

import it.ness.queryable.model.FilterDefBase;
import it.ness.queryable.model.QFilterDef;
import it.ness.queryable.model.QLikeFilterDef;
import it.ness.queryable.model.QLikeListFilterDef;
import it.ness.queryable.model.QListFilterDef;
import it.ness.queryable.model.QLogicalDeleteFilterDef;
import it.ness.queryable.model.QNilFilterDef;
import it.ness.queryable.model.QNotNilFilterDef;
import it.ness.queryable.model.enums.FilterType;
import it.ness.queryable.model.pojo.Parameters;
import it.ness.queryable.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class ModelFiles {
    private String[] modelFileNames;
    public boolean isParsingSuccessful = false;
    private Map<String, Map<FilterType, LinkedHashSet<FilterDefBase>>> filterDefMap = new LinkedHashMap<String, Map<FilterType, LinkedHashSet<FilterDefBase>>>();
    private Map<String, String> rsPathMap = new LinkedHashMap<String, String>();
    private Map<String, String> defaultOrderByMap = new LinkedHashMap<String, String>();
    private Map<String, Boolean> excludeClassMap = new LinkedHashMap<String, Boolean>();
    private Map<String, String> qualifiedClassName = new LinkedHashMap<String, String>();

    public ModelFiles(Log log, Parameters parameters) {
        File f;
        if (log != null) {
            log.info((CharSequence)("path = " + parameters.modelPath));
        }
        if (!(f = new File(parameters.modelPath)).exists()) {
            log.error((CharSequence)String.format("Path %s doesn't exist.", parameters.modelPath));
            return;
        }
        this.modelFileNames = f.list((f1, name) -> name.endsWith(".java"));
        if (this.modelFileNames != null && this.modelFileNames.length > 0) {
            if (log != null) {
                log.info((CharSequence)("Total model classes found : " + this.modelFileNames.length));
            }
            if (log != null) {
                log.info((CharSequence)("model class file names : " + Arrays.toString(this.modelFileNames)));
            }
            this.resolveConstant(log, parameters);
            this.isParsingSuccessful = this.resolveFilterDefs(log, parameters);
        } else {
            log.error((CharSequence)("No model classes found in path :" + parameters.modelPath));
        }
    }

    public Set<FilterDefBase> getFilterDef(String className, FilterType filterType) {
        if (this.excludeClass(className).booleanValue()) {
            return null;
        }
        Map<FilterType, LinkedHashSet<FilterDefBase>> allFilterDefs = this.filterDefMap.get(className);
        if (allFilterDefs == null) {
            return null;
        }
        return allFilterDefs.get((Object)filterType);
    }

    public String[] getModelFileNames() {
        return this.modelFileNames;
    }

    public String getRsPath(String className) {
        return this.rsPathMap.get(className);
    }

    public String getDefaultOrderBy(String className) {
        return this.defaultOrderByMap.get(className);
    }

    public String getQualifiedClassName(String className) {
        return this.qualifiedClassName.get(className);
    }

    public Boolean excludeClass(String className) {
        return this.excludeClassMap.get(className);
    }

    private void resolveConstant(Log log, Parameters parameters) {
        for (String fileName : this.modelFileNames) {
            String className = StringUtil.getClassNameFromFileName(fileName);
            String defaultRsPath = "NOT_SET";
            String defaultOrderBy = "not_set";
            String rsPath = "NOT_SET";
            String orderBy = "not_set";
            Boolean excludeClass = false;
            try {
                JavaClassSource javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)new File(parameters.modelPath, fileName));
                AnnotationSource a = javaClass.getAnnotation("QExclude");
                if (null != a) {
                    excludeClass = true;
                }
                if (null != (a = javaClass.getAnnotation("QRs"))) {
                    rsPath = a.getStringValue();
                    rsPath = StringUtil.removeQuotes(rsPath);
                }
                if (null != (a = javaClass.getAnnotation("QOrderBy"))) {
                    orderBy = a.getStringValue();
                    orderBy = StringUtil.removeQuotes(orderBy);
                }
                this.qualifiedClassName.put(className, javaClass.getQualifiedName());
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            this.rsPathMap.put(className, rsPath);
            this.defaultOrderByMap.put(className, orderBy);
            this.excludeClassMap.put(className, excludeClass);
            if (excludeClass.booleanValue()) continue;
            if ("not_set".equals(orderBy) && log != null) {
                log.warn((CharSequence)String.format("orderBy for class %s : %s", className, orderBy));
            }
            if (!"NOT_SET".equals(rsPath) || log == null) continue;
            log.warn((CharSequence)String.format("rsPath for class %s : %s", className, rsPath));
        }
    }

    private boolean resolveFilterDefs(Log log, Parameters parameters) {
        int i;
        HashSet<String> resolvedModels = new HashSet<String>();
        HashSet<FilterDefBase> filterDefBases = new HashSet<FilterDefBase>();
        filterDefBases.add(new QFilterDef(log));
        filterDefBases.add(new QLikeFilterDef(log));
        filterDefBases.add(new QNilFilterDef(log));
        filterDefBases.add(new QNotNilFilterDef(log));
        filterDefBases.add(new QLogicalDeleteFilterDef(log));
        filterDefBases.add(new QListFilterDef(log));
        filterDefBases.add(new QLikeListFilterDef(log));
        int maxInterations = 5;
        for (i = 1; resolvedModels.size() < this.modelFileNames.length && i <= 5; ++i) {
            if (log != null) {
                log.info((CharSequence)("parsing iteration : " + i));
            }
            for (String fileName : this.modelFileNames) {
                String modelName = StringUtil.getClassNameFromFileName(fileName);
                if (resolvedModels.contains(modelName)) continue;
                if (this.excludeClass(modelName).booleanValue()) {
                    if (log != null) {
                        log.info((CharSequence)String.format("Class %s is excluded from parsing", modelName));
                    }
                    resolvedModels.add(modelName);
                    continue;
                }
                try {
                    JavaClassSource javaClass;
                    String superClassName;
                    if (log != null) {
                        log.info((CharSequence)("Parsing : " + fileName));
                    }
                    if ((superClassName = (javaClass = (JavaClassSource)Roaster.parse(JavaClassSource.class, (File)new File(parameters.modelPath, fileName))).getSuperType()).contains(".")) {
                        superClassName = superClassName.substring(superClassName.lastIndexOf(46) + 1);
                    }
                    if (!superClassName.equals("PanacheEntityBase") && !resolvedModels.contains(superClassName)) continue;
                    LinkedHashMap allFilterDefs = new LinkedHashMap();
                    if (resolvedModels.contains(superClassName)) {
                        if (log != null) {
                            log.info((CharSequence)("Inheriting ALL FilterDefs for class " + modelName + " from " + superClassName));
                        }
                        Map<FilterType, LinkedHashSet<FilterDefBase>> allInheritedFilterDefs = this.filterDefMap.get(superClassName);
                        for (FilterType filterType : allInheritedFilterDefs.keySet()) {
                            LinkedHashSet filterTypeSet = (LinkedHashSet)allFilterDefs.get((Object)filterType);
                            if (filterTypeSet == null) {
                                filterTypeSet = new LinkedHashSet();
                            }
                            filterTypeSet.addAll(allInheritedFilterDefs.get((Object)filterType));
                            allFilterDefs.put(filterType, filterTypeSet);
                        }
                    }
                    boolean qClassLevelAnnotation = false;
                    for (AnnotationSource a : javaClass.getAnnotations()) {
                        if (!a.getName().equals("Q")) continue;
                        if (log != null) {
                            log.info((CharSequence)String.format("Class %s has Q annotation at class level", modelName));
                        }
                        qClassLevelAnnotation = true;
                    }
                    List fields = javaClass.getFields();
                    String entityName = javaClass.getName();
                    for (FieldSource f : fields) {
                        for (FilterDefBase fdbase : filterDefBases) {
                            FilterDefBase fd = fdbase.parseQFilterDef(entityName, (FieldSource<JavaClassSource>)f, qClassLevelAnnotation);
                            if (null == fd) continue;
                            FilterType filterType = fd.getFilterType();
                            LinkedHashSet<FilterDefBase> filterTypeSet = (LinkedHashSet<FilterDefBase>)allFilterDefs.get((Object)filterType);
                            if (filterTypeSet == null) {
                                filterTypeSet = new LinkedHashSet<FilterDefBase>();
                            }
                            if (fd.overrideOnSameFilterName() && filterTypeSet.contains(fd)) {
                                if (log != null) {
                                    log.info((CharSequence)("Override of filterdef " + fd.toString()));
                                }
                                filterTypeSet.remove(fd);
                            }
                            filterTypeSet.add(fd);
                            allFilterDefs.put(filterType, filterTypeSet);
                        }
                    }
                    for (FilterType filterType : allFilterDefs.keySet()) {
                        LinkedHashSet filterTypeSet = (LinkedHashSet)allFilterDefs.get((Object)filterType);
                        for (FilterDefBase fd : filterTypeSet) {
                            if (log == null) continue;
                            log.info((CharSequence)String.format("class %s extends %s: %s", modelName, superClassName, fd.toString()));
                        }
                    }
                    this.filterDefMap.put(modelName, allFilterDefs);
                    resolvedModels.add(modelName);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        if (i > 5) {
            log.error((CharSequence)"Parsing failed : Not all model files parsed. ALL Model classes must extend PanacheEntityBase.");
            return false;
        }
        if (log != null) {
            log.info((CharSequence)"All model files parsed.");
        }
        return true;
    }
}

