/*
 * Decompiled with CFR 0.152.
 */
package it.ness.queryable.util;

import it.ness.queryable.builder.OpenApiBuilder;
import it.ness.queryable.builder.QueryableBuilder;
import it.ness.queryable.builder.TestBuilder;
import it.ness.queryable.model.pojo.Data;
import it.ness.queryable.model.pojo.Parameters;
import it.ness.queryable.util.FileUtils;
import it.ness.queryable.util.ModelFiles;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.logging.Log;

public class MojoUtils {
    public static void addApi(Parameters parameters, Log log) {
        FileUtils.createPath(parameters.outputDir, parameters.apiPath, (Log)(parameters.logging ? log : null));
        File filterPath = FileUtils.createPath(parameters.outputDir, parameters.apiPath + "/filter/", (Log)(parameters.logging ? log : null));
        File producerPath = FileUtils.createPath(parameters.outputDir, parameters.apiPath + "/producer/", (Log)(parameters.logging ? log : null));
        File utilPath = FileUtils.createPath(parameters.outputDir, parameters.apiPath + "/util/", (Log)(parameters.logging ? log : null));
        File managementPath = FileUtils.createPath(parameters.outputDir, parameters.apiPath + "/management/", (Log)(parameters.logging ? log : null));
        File servicePath = FileUtils.createPath(parameters.outputDir, parameters.apiPath + "/service/", (Log)(parameters.logging ? log : null));
        Map<String, Object> data = Data.with("groupId", parameters.groupId).map();
        FileUtils.createJavaClassFromTemplate(filterPath, "CorsFilter", null, data, (Log)(parameters.logging ? log : null));
        FileUtils.createJavaClassFromTemplate(utilPath, "DateUtils", null, data, (Log)(parameters.logging ? log : null));
        FileUtils.createJavaClassFromTemplate(producerPath, "CorsExceptionMapper", null, data, (Log)(parameters.logging ? log : null));
        FileUtils.createJavaClassFromTemplate(managementPath, "AppConstants", null, data, (Log)(parameters.logging ? log : null));
        FileUtils.createJavaClassFromTemplate(servicePath, "RsRepositoryServiceV3", null, data, (Log)(parameters.logging ? log : null));
        FileUtils.createJavaClassFromTemplate(servicePath, "RsResponseService", null, data, (Log)(parameters.logging ? log : null));
    }

    public static void greeting(Parameters parameters, Log log) {
        FileUtils.createPath(parameters.outputDir, parameters.projectPath, (Log)(parameters.logging ? log : null));
        File modelPath = FileUtils.createPath(parameters.outputDir, parameters.projectPath + "/model/", (Log)(parameters.logging ? log : null));
        File enumPath = FileUtils.createPath(parameters.outputDir, parameters.projectPath + "/model/enums/", (Log)(parameters.logging ? log : null));
        File managementPath = FileUtils.createPath(parameters.outputDir, parameters.projectPath + "/management/", (Log)(parameters.logging ? log : null));
        Map<String, Object> data = Data.with("groupId", parameters.groupId).and("artifactId", parameters.artifactId).map();
        FileUtils.createJavaClassFromTemplate(managementPath, "AppConstantsApp", "AppConstants", data, (Log)(parameters.logging ? log : null));
        FileUtils.createJavaClassFromTemplate(enumPath, "GreetingEnum", null, data, (Log)(parameters.logging ? log : null));
        FileUtils.createJavaClassFromTemplate(modelPath, "Greeting", null, data, (Log)(parameters.logging ? log : null));
    }

    public static void source(Parameters parameters, Log log) {
        ModelFiles mf = new ModelFiles((Log)(parameters.logging ? log : null), parameters);
        if (!mf.isParsingSuccessful) {
            return;
        }
        try {
            QueryableBuilder.generateSources(mf, (Log)(parameters.logging ? log : null), parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void testsource(Parameters parameters, Log log) {
        ModelFiles mf = new ModelFiles((Log)(parameters.logging ? log : null), parameters);
        if (!mf.isParsingSuccessful) {
            return;
        }
        try {
            String packageName = parameters.groupId + "." + parameters.artifactId;
            TestBuilder.generateSources(mf, log, parameters, packageName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void openapisource(Parameters parameters, Log log) {
        ModelFiles mf = new ModelFiles((Log)(parameters.logging ? log : null), parameters);
        if (!mf.isParsingSuccessful) {
            return;
        }
        try {
            String packageName = parameters.groupId + "." + parameters.artifactId;
            OpenApiBuilder.generateSources(mf, log, parameters, packageName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static Model parsePomXmlFileToMavenPomModel(String path) throws Exception {
        Model model = null;
        FileReader reader = null;
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        reader = new FileReader(path);
        model = mavenreader.read((Reader)reader);
        return model;
    }

    public static void parseMavenPomModelToXmlString(String path, Model model) throws Exception {
        MavenXpp3Writer mavenWriter = new MavenXpp3Writer();
        FileWriter writer = new FileWriter(path);
        mavenWriter.write((Writer)writer, model);
    }

    public static void addQueryableDependency(Model model) {
        Dependency dependency = new Dependency();
        dependency.setGroupId("it.n-ess.queryable");
        dependency.setArtifactId("queryable-maven-plugin");
        dependency.setVersion("1.0.14");
        model.addDependency(dependency);
    }

    public static void addQueryablePlugin(Model model) {
        Plugin plugin = new Plugin();
        plugin.setGroupId("it.n-ess.queryable");
        plugin.setArtifactId("queryable-maven-plugin");
        plugin.setVersion("1.0.14");
        model.getBuild().addPlugin(plugin);
    }
}

