/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.woocommerce;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriBuilder;

@PreMatching
public class OAuth10aFilter
implements ClientRequestFilter {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final String HMAC_SHA1_SIGNATURE_METHOD = "HMAC-SHA1";
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private final String consumerSecret;
    private final String consumerKey;

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static String generateNonce() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private static String generateTimestamp() {
        long unixTime = System.currentTimeMillis() / 1000L;
        return String.valueOf(unixTime);
    }

    private static String encodeQueryParamsInUri(URI uri) {
        String[] pairs;
        TreeMap<String, String> queryParms = new TreeMap<String, String>();
        String query = uri.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            queryParms.put(pair.substring(0, idx), pair.substring(idx + 1));
        }
        String output = "";
        Set querySet = queryParms.entrySet();
        Iterator setIterator = querySet.iterator();
        while (setIterator.hasNext()) {
            if (output != "") {
                output = output + "&";
            }
            Map.Entry param = setIterator.next();
            output = output + (String)param.getKey() + "=" + (String)param.getValue();
        }
        return output;
    }

    private String getUrlWithoutParameters(URI uri) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null).toString();
    }

    public OAuth10aFilter(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        String message_to_sign = "";
        UriBuilder builder = UriBuilder.fromUri((URI)requestContext.getUri());
        builder.queryParam("oauth_consumer_key", new Object[]{this.getConsumerKey()});
        builder.queryParam("oauth_timestamp", new Object[]{OAuth10aFilter.generateTimestamp()});
        builder.queryParam("oauth_nonce", new Object[]{OAuth10aFilter.generateNonce()});
        builder.queryParam("oauth_signature_method", new Object[]{HMAC_SHA1_SIGNATURE_METHOD});
        URI uri_to_sign = builder.build(new Object[0]);
        String encodedParams = OAuth10aFilter.encodeQueryParamsInUri(uri_to_sign);
        try {
            message_to_sign = requestContext.getMethod() + "&" + URLEncoder.encode(this.getUrlWithoutParameters(uri_to_sign), StandardCharsets.US_ASCII.toString()) + "&" + URLEncoder.encode(encodedParams, StandardCharsets.US_ASCII.toString());
        }
        catch (URISyntaxException e1) {
            // empty catch block
        }
        builder.queryParam("oauth_signature", new Object[]{this.calculateHmacSHA1Signature(message_to_sign)});
        requestContext.setUri(builder.build(new Object[0]));
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    private String calculateHmacSHA1Signature(String message_to_sign) {
        String signature = "";
        SecretKeySpec signingKey = new SecretKeySpec((this.consumerSecret + "&").getBytes(), HMAC_SHA1_ALGORITHM);
        try {
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(message_to_sign.getBytes());
            signature = Base64.getEncoder().encodeToString(rawHmac);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

