/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.woocommerce.jersey.bulk;

import it.netgrid.woocommerce.BulkService;
import it.netgrid.woocommerce.CrudObject;
import it.netgrid.woocommerce.jersey.FilterQuery;
import it.netgrid.woocommerce.model.BatchOperation;
import it.netgrid.woocommerce.model.response.CountResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

public abstract class TemplateBulkService<T extends CrudObject<ID>, ID, C, R, S>
implements BulkService<T, ID, C> {
    public static final String FILTER_QUERY_FORMAT = "filter[%s]";
    private final WebTarget target;

    protected TemplateBulkService(WebTarget target) {
        this.target = target;
    }

    private List<T> getUpdatedRows(BatchOperation<T> ba) {
        ArrayList<T> result = new ArrayList<T>();
        List<T> create = ba.getCreate();
        List<T> update = ba.getUpdate();
        List<T> delete = ba.getDelete();
        if (create != null) {
            result.addAll(create);
        }
        if (update != null) {
            result.addAll(update);
        }
        if (delete != null) {
            result.addAll(delete);
        }
        return result;
    }

    @Override
    public List<T> write(List<T> items, C context) {
        Invocation.Builder builder = this.initBuilder(this.getWritePath(context), null, null);
        Entity request = Entity.entity(new BatchOperation<T>(null, items, null), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        BatchOperation result = (BatchOperation)builder.post(request, new BatchOperation().getClass());
        return this.getUpdatedRows(result);
    }

    @Override
    public List<T> read(C context) {
        return this.read(context, null, null);
    }

    @Override
    public List<T> read(C context, FilterQuery filter, Map<String, String> queryParams) {
        Invocation.Builder builder = this.initBuilder(this.getReadPath(context), filter, queryParams);
        Object result = builder.get(this.getResponseClass());
        return this.getResult(result);
    }

    @Override
    public Integer count(C context, FilterQuery filter, Map<String, String> queryParams) {
        Invocation.Builder builder = this.initBuilder(this.getReadPath(context), filter, queryParams);
        CountResponse result = (CountResponse)builder.get(CountResponse.class);
        return result.getCount();
    }

    public Invocation.Builder initBuilder(String path, FilterQuery filter, Map<String, String> queryParams) {
        WebTarget target = this.target;
        if (path != null && !path.trim().equals("")) {
            target = target.path(path);
        }
        if (filter != null) {
            Map<String, String> flat = filter.toFlatMap();
            for (String param : flat.keySet()) {
                target = target.queryParam(param, new Object[]{flat.get(param)});
            }
        }
        if (queryParams != null) {
            for (String param : queryParams.keySet()) {
                target = target.queryParam(param, new Object[]{queryParams.get(param)});
            }
        }
        return target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    public Entity<R> getRequestEntity(List<T> object) {
        R request = this.getWriteRequest(object);
        return Entity.entity(request, (MediaType)MediaType.APPLICATION_JSON_TYPE);
    }

    public abstract String getWritePath(C var1);

    public abstract String getReadPath(C var1);

    public abstract String getCountPath(C var1);

    public abstract Class<S> getResponseClass();

    public abstract R getWriteRequest(List<T> var1);

    public abstract List<T> getResult(S var1);
}

