/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.woocommerce.jersey.crud;

import it.netgrid.woocommerce.CrudObject;
import it.netgrid.woocommerce.CrudService;
import it.netgrid.woocommerce.model.response.DeleteResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

public abstract class TemplateCrudService<T extends CrudObject<ID>, ID, C, R, S>
implements CrudService<T, ID, C> {
    private final WebTarget target;

    protected TemplateCrudService(WebTarget target) {
        this.target = target;
    }

    @Override
    public T create(T object, C context) throws IllegalArgumentException {
        Invocation.Builder builder = this.initBuilder(this.getCreatePath(context));
        Object result = builder.post(this.getRequestEntity(object), this.getResponseClass());
        return this.getResult(result);
    }

    @Override
    public T read(ID key, C context) throws IllegalArgumentException {
        Invocation.Builder builder = this.initBuilder(this.getReadPath(key, context));
        Object result = builder.get(this.getResponseClass());
        return this.getResult(result);
    }

    @Override
    public T update(T object, C context) throws IllegalArgumentException {
        Invocation.Builder builder = this.initBuilder(this.getUpdatePath(object.getId(), context));
        Object result = builder.put(this.getRequestEntity(object), this.getResponseClass());
        return this.getResult(result);
    }

    @Override
    public T delete(T object, C context) throws IllegalArgumentException {
        Invocation.Builder builder = this.initBuilder(this.getDeletePath(object.getId(), context));
        DeleteResponse result = (DeleteResponse)builder.delete(DeleteResponse.class);
        return result == null ? null : (T)object;
    }

    public Invocation.Builder initBuilder(String path) {
        if (path == null || path.trim().equals("")) {
            return this.target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        }
        return this.target.path(path).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    public Entity<R> getRequestEntity(T object) {
        R request = this.getRequest(object);
        return Entity.entity(request, (MediaType)MediaType.APPLICATION_JSON_TYPE);
    }

    public abstract String getCreatePath(C var1);

    public abstract String getReadPath(ID var1, C var2);

    public abstract String getUpdatePath(ID var1, C var2);

    public abstract String getDeletePath(ID var1, C var2);

    public abstract Class<S> getResponseClass();

    public abstract R getRequest(T var1);

    public abstract T getResult(S var1);
}

