/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.squarespace.jersey2.guice.JerseyGuiceModule;
import com.squarespace.jersey2.guice.JerseyGuiceUtils;
import it.netgrid.lovelace.Configuration;
import it.netgrid.lovelace.GuiceConfig;
import it.netgrid.lovelace.PropertiesConfigurationImpl;
import it.netgrid.lovelace.api.ApiModule;
import it.netgrid.lovelace.model.DaoModule;
import it.netgrid.lovelace.model.JdbcConnectionModule;
import it.netgrid.lovelace.quartz.GuiceJobFactory;
import it.netgrid.lovelace.quartz.LovelaceSchedulerListener;
import it.netgrid.lovelace.quartz.RunStatusJobListener;
import it.netgrid.lovelace.quartz.RunStatusTriggerListener;
import it.netgrid.lovelace.rest.IllegalArgumentExceptionMapper;
import it.netgrid.lovelace.rest.NullPointerExceptionMapper;
import it.netgrid.lovelace.rest.SQLExceptionMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.glassfish.jersey.servlet.ServletContainer;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static Configuration config;
    private static Scheduler scheduler;
    private static Server server;
    private static Injector injector;
    private static List<Module> modules;

    public static void main(String[] args) throws IOException {
        config = args.length > 1 ? new PropertiesConfigurationImpl(args[1]) : new PropertiesConfigurationImpl();
        modules = new ArrayList<Module>();
        Main.run();
    }

    public static void mainWithInjectableModulesAndConfig(List<Module> modules, Configuration config) throws IOException {
        Main.config = config;
        Main.modules = modules;
        Main.run();
    }

    private static void run() throws IOException {
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
            injector = Main.createInjector();
            scheduler.setJobFactory((JobFactory)injector.getInstance(GuiceJobFactory.class));
            server = new Server(new InetSocketAddress(config.getBindAddress(), config.getBindPort()));
            JerseyGuiceUtils.install((Injector)injector);
            WebAppContext webAppContext = new WebAppContext();
            webAppContext.setContextPath("/");
            ServletHolder sh = webAppContext.addServlet(ServletContainer.class, "/*");
            sh.setInitParameter("javax.ws.rs.Application", "it.netgrid.lovelace.Application");
            webAppContext.addFilter(GuiceFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            webAppContext.addEventListener((EventListener)injector.getInstance(GuiceConfig.class));
            webAppContext.setResourceBase(System.getProperty("java.io.tmpdir"));
            server.setHandler((Handler)webAppContext);
            try {
                scheduler.start();
                server.start();
                server.join();
                scheduler.shutdown();
            }
            catch (InterruptedException e) {
                log.warn("Server shutdown", (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Runtime error", (Throwable)e);
            }
        }
        catch (SchedulerException e) {
            log.error("Cannot init scheduler", (Throwable)e);
        }
    }

    protected static Scheduler getScheduler() {
        return scheduler;
    }

    protected static Injector createInjector() {
        modules.add((Module)new JerseyGuiceModule("__HK2_Generated_0"));
        modules.add((Module)new ServletModule(){

            protected void configureServlets() {
                this.bind(SQLExceptionMapper.class);
                this.bind(IllegalArgumentExceptionMapper.class);
                this.bind(NullPointerExceptionMapper.class);
            }
        });
        if (!config.hasJdbcConnectionReuse()) {
            modules.add((Module)new JdbcConnectionModule());
        }
        modules.add((Module)new DaoModule());
        modules.add((Module)new ApiModule());
        modules.add((Module)new AbstractModule(){

            protected void configure() {
            }

            @Provides
            @Singleton
            public Configuration getConfig() {
                return config;
            }

            @Provides
            @Singleton
            public Scheduler getScheduler(LovelaceSchedulerListener schedulerListener, RunStatusJobListener jobListener, RunStatusTriggerListener triggerListener) throws SchedulerException {
                scheduler.getListenerManager().addSchedulerListener((SchedulerListener)schedulerListener);
                scheduler.getListenerManager().addJobListener((JobListener)jobListener, (Matcher)GroupMatcher.groupEquals((String)config.getQuartzGroupName()));
                scheduler.getListenerManager().addTriggerListener((TriggerListener)triggerListener, (Matcher)GroupMatcher.groupEquals((String)config.getQuartzGroupName()));
                return scheduler;
            }

            @Provides
            @Singleton
            public Server getServer() {
                return server;
            }
        });
        return Guice.createInjector(modules);
    }
}

