/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace;

import it.netgrid.lovelace.Configuration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigurationImpl
implements Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private static final String DEFAULT_CONFIG_PROPERTIES_PATH = "/etc/netgrid/lovelace/config.properties";
    private static final String DEFAULT_CONFIG_PROPERTIES_RESOURCE = "/config.properties";
    private static final String KEY_JDBC_CONNECTION_URL = "jdbcConnection";
    private static final String KEY_JDBC_USERNAME = "jdbcUsername";
    private static final String KEY_JDBC_PASSWORD = "jdbcPassword";
    private static final String KEY_BIND_ADDRESS = "bindAddress";
    private static final String KEY_BIND_PORT = "bindPort";
    private static final String KEY_SCHEDULER_ID = "schedulerId";
    private static final String KEY_JDBC_CONNECTION_REUSE = "jdbcConnectionReuse";
    private static final String DEFAULT_QUARTZ_GROUP_NAME = "global";
    private static final String DEFAULT_JDBC_CONNECITON_URL = "jdbc:h2:mem:lovelace?zeroDateTimeBehavior=convertToNull";
    private static final String DEFAULT_JDBC_USERNAME = "root";
    private static final String DEFAULT_JDBC_PASSWORD = "root";
    private static final String DEFAULT_BIND_ADDRESS = "127.0.0.1";
    private static final String DEFAULT_BIND_PORT = "9099";
    private static final String DEFAULT_SCHEDULER_ID = "1";
    private static final String DEFAULT_JDBC_CONNECTION_REUSE = "false";
    private Properties properties;

    public PropertiesConfigurationImpl() {
        this(null);
    }

    public PropertiesConfigurationImpl(String propertiesFilePathOrResourceName) {
        if (propertiesFilePathOrResourceName != null) {
            if (this.loadPropertiesFromFile(propertiesFilePathOrResourceName)) {
                return;
            }
            if (this.loadPropertiesAsResource(propertiesFilePathOrResourceName)) {
                return;
            }
        }
        if (this.loadPropertiesFromFile(DEFAULT_CONFIG_PROPERTIES_PATH)) {
            return;
        }
        this.loadPropertiesAsResource(DEFAULT_CONFIG_PROPERTIES_RESOURCE);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    private boolean loadPropertiesAsResource(String propertiesResourceName) {
        if (this.properties == null) {
            try (InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(propertiesResourceName);){
                this.properties = new Properties();
                this.properties.load(resourceStream);
            }
            catch (NullPointerException e) {
                log.warn("Unable to load properties");
            }
            catch (IOException e) {
                log.warn(String.format("Unable to load config resource: %s", propertiesResourceName), (Throwable)e);
            }
        }
        return this.properties != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadPropertiesFromFile(String filePath) {
        if (this.properties == null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                log.warn(String.format("Unable to load config file: %s", filePath), (Throwable)e);
            }
            if (in != null) {
                try {
                    this.properties = new Properties();
                    this.properties.load(in);
                }
                catch (IOException e) {
                    log.warn("Invalid properties file format", (Throwable)e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.debug("Input stream already closed");
                    }
                }
            }
        }
        return this.properties != null;
    }

    @Override
    public String getJdbcConnectionUrl() {
        return this.getProperties().getProperty(KEY_JDBC_CONNECTION_URL, DEFAULT_JDBC_CONNECITON_URL);
    }

    @Override
    public String getJdbcUsername() {
        return this.getProperties().getProperty(KEY_JDBC_USERNAME, "root");
    }

    @Override
    public String getJdbcPassword() {
        return this.getProperties().getProperty(KEY_JDBC_PASSWORD, "root");
    }

    @Override
    public String getBindAddress() {
        return this.getProperties().getProperty(KEY_BIND_ADDRESS, DEFAULT_BIND_ADDRESS);
    }

    @Override
    public int getBindPort() {
        return Integer.parseInt(this.getProperties().getProperty(KEY_BIND_PORT, DEFAULT_BIND_PORT));
    }

    @Override
    public String getQuartzGroupName() {
        return DEFAULT_QUARTZ_GROUP_NAME;
    }

    @Override
    public Long getSchedulerId() {
        return Long.parseLong(this.getProperties().getProperty(KEY_SCHEDULER_ID, DEFAULT_SCHEDULER_ID));
    }

    @Override
    public boolean hasJdbcConnectionReuse() {
        return Boolean.getBoolean(this.getProperties().getProperty(KEY_JDBC_CONNECTION_REUSE, DEFAULT_JDBC_CONNECTION_REUSE));
    }
}

