/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.api;

import com.google.inject.Inject;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import it.netgrid.commons.ormlite.TemplateCrudService;
import it.netgrid.lovelace.model.RunStatus;
import it.netgrid.lovelace.model.StepStatus;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.lang3.Validate;

public class RunStatusCrudService
extends TemplateCrudService<RunStatus, Long> {
    public static final String INVALID_TASK = "task";
    private final Dao<RunStatus, Long> runStatusDao;
    private final Dao<StepStatus, Long> stepStatusDao;

    @Inject
    public RunStatusCrudService(ConnectionSource connection, Dao<RunStatus, Long> runStatusDao, Dao<StepStatus, Long> stepStatusDao) {
        super(connection);
        this.runStatusDao = runStatusDao;
        this.stepStatusDao = stepStatusDao;
    }

    public int createRaw(RunStatus run) throws SQLException, IllegalArgumentException {
        Validate.notNull((Object)run.getTaskStatus(), (String)INVALID_TASK, (Object[])new Object[0]);
        run.setCreationDate(new Date());
        return this.runStatusDao.create((Object)run);
    }

    public int deleteRaw(RunStatus run) throws SQLException, IllegalArgumentException {
        return this.runStatusDao.delete((Object)run);
    }

    public int updateRaw(RunStatus run) throws SQLException, IllegalArgumentException {
        return this.runStatusDao.update((Object)run);
    }

    public RunStatus read(Long key) throws SQLException {
        RunStatus retval = (RunStatus)this.runStatusDao.queryForId((Object)key);
        for (StepStatus step : retval.getStepsStatus()) {
            this.stepStatusDao.refresh((Object)step);
            retval.getSteps().add(step);
        }
        return retval;
    }
}

