/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import it.netgrid.commons.data.CrudObject;
import it.netgrid.commons.data.CrudService;
import it.netgrid.lovelace.api.StepService;
import it.netgrid.lovelace.model.ExecutionResult;
import it.netgrid.lovelace.model.ExecutionState;
import it.netgrid.lovelace.model.RunStatus;
import it.netgrid.lovelace.model.StepStatus;
import it.netgrid.lovelace.model.TaskStatus;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StepServiceImpl
implements StepService {
    private static final Logger log = LoggerFactory.getLogger(StepServiceImpl.class);
    private final CrudService<StepStatus, Long> stepStatusService;
    private final Dao<RunStatus, Long> runStatusDao;
    private final Dao<StepStatus, Long> stepStatusDao;
    private final ConnectionSource connection;
    private final CrudService<RunStatus, Long> runStatusService;
    private final CrudService<TaskStatus, Long> taskStatusService;
    private final Dao<TaskStatus, Long> taskStatusDao;

    @Inject
    public StepServiceImpl(Dao<TaskStatus, Long> taskStatusDao, ConnectionSource connection, Dao<RunStatus, Long> runStatusDao, Dao<StepStatus, Long> stepStatusDao, CrudService<StepStatus, Long> stepStatusService, CrudService<RunStatus, Long> runStatusService, CrudService<TaskStatus, Long> taskStatusService) {
        this.taskStatusDao = taskStatusDao;
        this.stepStatusService = stepStatusService;
        this.runStatusDao = runStatusDao;
        this.stepStatusDao = stepStatusDao;
        this.connection = connection;
        this.runStatusService = runStatusService;
        this.taskStatusService = taskStatusService;
    }

    @Override
    public StepStatus start(final TaskStatus task, final String firstStepName, final int totalStepsCount) {
        StepStatus runStatus = null;
        try {
            runStatus = (StepStatus)TransactionManager.callInTransaction((ConnectionSource)this.connection, (Callable)new Callable<StepStatus>(){

                @Override
                public StepStatus call() throws Exception {
                    RunStatus runStatus = StepServiceImpl.this.buildRunStatus(task);
                    runStatus.setTotalStepsCount(totalStepsCount);
                    StepServiceImpl.this.runStatusService.createRaw((CrudObject)runStatus);
                    task.setCurrentRun(runStatus);
                    StepServiceImpl.this.taskStatusService.updateRaw((CrudObject)task);
                    StepStatus stepStatus = StepServiceImpl.this.buildStepStatus(runStatus, firstStepName);
                    StepServiceImpl.this.stepStatusService.createRaw((CrudObject)stepStatus);
                    runStatus.setCurrentStep(stepStatus);
                    StepServiceImpl.this.runStatusService.updateRaw((CrudObject)runStatus);
                    StepServiceImpl.this.runStatusDao.refresh((Object)stepStatus.getRunStatus());
                    return stepStatus;
                }
            });
        }
        catch (SQLException e) {
            log.error("Unable to update task status", (Throwable)e);
        }
        return runStatus;
    }

    @Override
    public StepStatus nextStep(final TaskStatus task, final ExecutionResult currentStepResult, final String nextStepName) {
        StepStatus runStatus = null;
        try {
            runStatus = (StepStatus)TransactionManager.callInTransaction((ConnectionSource)this.connection, (Callable)new Callable<StepStatus>(){

                @Override
                public StepStatus call() throws Exception {
                    StepServiceImpl.this.runStatusDao.refresh((Object)task.getCurrentRun());
                    RunStatus runStatus = task.getCurrentRun();
                    StepStatus oldStepStatus = StepServiceImpl.this.getCurrentStep(runStatus);
                    StepServiceImpl.this.end(oldStepStatus, currentStepResult);
                    StepStatus stepStatus = StepServiceImpl.this.buildStepStatus(runStatus, nextStepName);
                    StepServiceImpl.this.stepStatusService.createRaw((CrudObject)stepStatus);
                    runStatus.setCurrentStep(stepStatus);
                    StepServiceImpl.this.runStatusService.updateRaw((CrudObject)runStatus);
                    stepStatus = (StepStatus)StepServiceImpl.this.stepStatusService.read((Object)stepStatus.getId());
                    StepServiceImpl.this.runStatusDao.refresh((Object)stepStatus.getRunStatus());
                    return stepStatus;
                }
            });
        }
        catch (SQLException e) {
            log.error("Unable to update task status", (Throwable)e);
        }
        return runStatus;
    }

    @Override
    public StepStatus end(final TaskStatus task, final ExecutionResult currentStepResult, final ExecutionResult taskResult) {
        StepStatus runStatus = null;
        try {
            runStatus = (StepStatus)TransactionManager.callInTransaction((ConnectionSource)this.connection, (Callable)new Callable<StepStatus>(){

                @Override
                public StepStatus call() throws Exception {
                    StepServiceImpl.this.runStatusDao.refresh((Object)task.getCurrentRun());
                    RunStatus run = task.getCurrentRun();
                    StepStatus stepStatus = StepServiceImpl.this.getCurrentStep(run);
                    StepServiceImpl.this.end(stepStatus, currentStepResult);
                    run.setEndDate(new Date());
                    run.setResult(taskResult);
                    run.setState(ExecutionState.END);
                    run.setCurrentStep(null);
                    StepServiceImpl.this.runStatusService.updateRaw((CrudObject)run);
                    task.setLastRun(run);
                    task.setCurrentRun(null);
                    if (taskResult == ExecutionResult.SUCCESS) {
                        task.setLastSuccessRun(run);
                    }
                    StepServiceImpl.this.taskStatusService.updateRaw((CrudObject)task);
                    return (StepStatus)StepServiceImpl.this.stepStatusService.read((Object)stepStatus.getId());
                }
            });
        }
        catch (SQLException e) {
            log.error("Unable to update task status", (Throwable)e);
        }
        return runStatus;
    }

    private StepStatus getCurrentStep(RunStatus runStatus) {
        QueryBuilder query = this.stepStatusDao.queryBuilder();
        try {
            query.where().eq("stp_run_id", (Object)runStatus.getId());
            List runSteps = query.orderBy("stp_start_time", false).query();
            if (runSteps.isEmpty()) {
                return null;
            }
            return (StepStatus)runSteps.get(0);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private void end(StepStatus step, ExecutionResult result) throws IllegalArgumentException, SQLException {
        this.stepStatusDao.refresh((Object)step);
        step.setEndTime(new Date());
        step.setState(ExecutionState.END);
        step.setResult(result);
        this.stepStatusService.updateRaw((CrudObject)step);
    }

    private StepStatus buildStepStatus(RunStatus runStatus, String stepName) {
        StepStatus runStep = new StepStatus();
        runStep.setName(stepName);
        runStep.setRunStatus(runStatus);
        runStep.setStartTime(new Date());
        runStep.setState(ExecutionState.RUN);
        return runStep;
    }

    private RunStatus buildRunStatus(TaskStatus task) {
        RunStatus retval = new RunStatus();
        retval.setStartDate(new Date());
        retval.setState(ExecutionState.RUN);
        retval.setTaskStatus(task);
        return retval;
    }

    @Override
    public StepStatus nextStep(JobExecutionContext context, ExecutionResult currentStepResult, String nextStepName) {
        TaskStatus task = this.getTaskStatus(context);
        return this.nextStep(task, currentStepResult, nextStepName);
    }

    @Override
    public TaskStatus getTaskStatus(JobExecutionContext context) {
        try {
            List result = this.taskStatusDao.queryForEq("tsk_name", (Object)context.getJobDetail().getKey().getName());
            if (result.isEmpty()) {
                return null;
            }
            return (TaskStatus)result.get(0);
        }
        catch (SQLException e) {
            log.warn("Unable to load task status from context", (Throwable)e);
            return null;
        }
    }
}

