/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.api;

import com.cronutils.validator.CronValidator;
import com.google.inject.Inject;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import it.netgrid.commons.SerializableUtils;
import it.netgrid.commons.data.CrudObject;
import it.netgrid.commons.data.CrudService;
import it.netgrid.commons.ormlite.TemplateCrudService;
import it.netgrid.lovelace.Configuration;
import it.netgrid.lovelace.model.RunStatus;
import it.netgrid.lovelace.model.SchedulerStatus;
import it.netgrid.lovelace.model.TaskStatus;
import it.netgrid.lovelace.quartz.SchedulerUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatusCrudService
extends TemplateCrudService<TaskStatus, Long> {
    private static final Logger log = LoggerFactory.getLogger(TaskStatusCrudService.class);
    public static final String INVALID_NAME = "name";
    public static final String INVALID_CANONICAL_NAME = "canonical_name";
    public static final String INVALID_SCHEDULER = "scheduler";
    public static final String INVALID_SCHEDULER_JOB_DETAILS = "scheduler/job_details";
    public static final String INVALID_SCHEDULER_TRIGGER = "scheduler/trigger";
    private final Configuration config;
    private final Scheduler scheduler;
    private final SchedulerUtils schedulerUtils;
    private final CronValidator cronValidator;
    private final Dao<TaskStatus, Long> taskStatusDao;
    private final CrudService<SchedulerStatus, Long> schedulerStatusService;
    private final CrudService<RunStatus, Long> runStatusService;

    @Inject
    public TaskStatusCrudService(ConnectionSource connection, SchedulerUtils schedulerUtils, Configuration config, Scheduler scheduler, CronValidator cronValidator, Dao<TaskStatus, Long> taskStatusDao, CrudService<RunStatus, Long> runStatusService, CrudService<SchedulerStatus, Long> schedulerStatusService) {
        super(connection);
        this.config = config;
        this.scheduler = scheduler;
        this.schedulerUtils = schedulerUtils;
        this.cronValidator = cronValidator;
        this.taskStatusDao = taskStatusDao;
        this.runStatusService = runStatusService;
        this.schedulerStatusService = schedulerStatusService;
    }

    public int createRaw(TaskStatus task) throws SQLException, IllegalArgumentException {
        Validate.notBlank((CharSequence)task.getName());
        this.cronValidator.validate(task.getSchedule());
        SchedulerStatus scheduler = (SchedulerStatus)this.schedulerStatusService.read((Object)this.config.getSchedulerId());
        task.setSchedulerStatus(scheduler);
        task.setCreation(new Date());
        task.setMarshalledConfig(this.getConfigString(task.getConfig()));
        task.setUpdated(task.getCreation());
        JobDetail detail = this.createJobDetail(task);
        Trigger trigger = this.getTrigger(task);
        int retval = this.taskStatusDao.create((Object)task);
        try {
            this.scheduler.scheduleJob(detail, trigger);
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException(INVALID_SCHEDULER);
        }
        return retval;
    }

    public int deleteRaw(TaskStatus task) throws SQLException, IllegalArgumentException {
        int retval = 0;
        for (RunStatus run : task.getTaskRuns()) {
            retval += this.runStatusService.deleteRaw((CrudObject)run);
        }
        retval += this.taskStatusDao.delete((Object)task);
        try {
            this.scheduler.deleteJob(this.schedulerUtils.getJobKey(task));
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException(INVALID_SCHEDULER);
        }
        return retval;
    }

    public int updateRaw(TaskStatus task) throws SQLException, IllegalArgumentException {
        TaskStatus oldTask = (TaskStatus)this.taskStatusDao.queryForId((Object)task.getId());
        if (!task.getName().equals(oldTask.getName())) {
            throw new IllegalArgumentException(INVALID_NAME);
        }
        if (!task.getCanonicalName().equals(oldTask.getCanonicalName())) {
            throw new IllegalArgumentException(INVALID_CANONICAL_NAME);
        }
        this.cronValidator.validate(task.getSchedule());
        int retval = 0;
        try {
            if (!oldTask.getConfig().equals(task.getConfig())) {
                JobDetail jobDetail = this.scheduler.getJobDetail(this.schedulerUtils.getJobKey(task));
                jobDetail.getJobDataMap().clear();
                jobDetail.getJobDataMap().putAll(task.getConfig());
                HashSet triggers = new HashSet(this.scheduler.getTriggersOfJob(this.schedulerUtils.getJobKey(task)));
                this.scheduler.scheduleJob(jobDetail, triggers, true);
            }
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException(INVALID_SCHEDULER_JOB_DETAILS);
        }
        try {
            if (!task.getSchedule().equals(oldTask.getSchedule())) {
                Trigger newTrigger = this.getTrigger(task);
                this.scheduler.rescheduleJob(this.schedulerUtils.getTriggerKey(task), newTrigger);
            }
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException(INVALID_SCHEDULER_TRIGGER);
        }
        oldTask.setConfig(task.getConfig());
        oldTask.setMarshalledConfig(this.getConfigString(task.getConfig()));
        oldTask.setSchedule(task.getSchedule());
        oldTask.setUpdated(new Date());
        oldTask.setCurrentRun(task.getCurrentRun());
        oldTask.setLastRun(task.getLastRun());
        oldTask.setLastSuccessRun(task.getLastSuccessRun());
        return retval += this.taskStatusDao.update((Object)oldTask);
    }

    public TaskStatus read(Long key) throws SQLException {
        RunStatus run;
        TaskStatus retval = (TaskStatus)this.taskStatusDao.queryForId((Object)key);
        if (retval == null) {
            return null;
        }
        retval.setConfig(this.getConfigMap(retval.getMarshalledConfig()));
        if (retval.getCurrentRun() != null) {
            run = (RunStatus)this.runStatusService.read((Object)retval.getCurrentRun().getId());
            retval.setCurrentRun(run);
        }
        if (retval.getLastRun() != null) {
            run = (RunStatus)this.runStatusService.read((Object)retval.getLastRun().getId());
            retval.setLastRun(run);
        }
        if (retval.getLastSuccessRun() != null) {
            run = (RunStatus)this.runStatusService.read((Object)retval.getLastSuccessRun().getId());
            retval.setLastSuccessRun(run);
        }
        try {
            Trigger trigger = this.scheduler.getTrigger(this.schedulerUtils.getTriggerKey(retval));
            retval.setNextRunTime(trigger.getNextFireTime());
        }
        catch (SchedulerException e) {
            log.warn("Unable to read trigger reference for task: " + retval.getName());
        }
        return retval;
    }

    public String getConfigString(Map<String, String> config) {
        if (config == null) {
            return null;
        }
        return SerializableUtils.serializeBase64(config);
    }

    public Map<String, String> getConfigMap(String config) {
        if (config == null) {
            return null;
        }
        return (Map)SerializableUtils.deserializeBase64((String)config);
    }

    private Trigger getTrigger(TaskStatus task) {
        Trigger retval = TriggerBuilder.newTrigger().withIdentity(this.schedulerUtils.getTriggerKey(task)).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)task.getSchedule())).forJob(this.schedulerUtils.getJobKey(task)).build();
        return retval;
    }

    private JobDetail createJobDetail(TaskStatus task) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(task.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(INVALID_CANONICAL_NAME, e);
        }
        JobDataMap dataMap = new JobDataMap(task.getConfig());
        JobDetail retval = JobBuilder.newJob(clazz).withIdentity(this.schedulerUtils.getJobKey(task)).setJobData(dataMap).build();
        return retval;
    }
}

