/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.model;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import it.netgrid.lovelace.Configuration;
import it.netgrid.lovelace.model.JdbcConnectionModule;
import it.netgrid.lovelace.model.RunStatus;
import it.netgrid.lovelace.model.SchedulerStatus;
import it.netgrid.lovelace.model.StepStatus;
import it.netgrid.lovelace.model.TaskStatus;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(DaoModule.class);

    protected void configure() {
    }

    @Provides
    @Singleton
    public Dao<StepStatus, Long> getRunStepStatusDao(Configuration config, ConnectionSource connectionSource) throws SQLException {
        if (!JdbcConnectionModule.areTableInitialized()) {
            JdbcConnectionModule.initTables(connectionSource);
        }
        return DaoManager.createDao((ConnectionSource)connectionSource, StepStatus.class);
    }

    @Provides
    @Singleton
    public Dao<SchedulerStatus, Long> getSystemStatusDao(ConnectionSource connectionSource) throws SQLException {
        if (!JdbcConnectionModule.areTableInitialized()) {
            JdbcConnectionModule.initTables(connectionSource);
        }
        return DaoManager.createDao((ConnectionSource)connectionSource, SchedulerStatus.class);
    }

    @Provides
    @Singleton
    public Dao<RunStatus, Long> getTaskRunStatusDao(ConnectionSource connectionSource) throws SQLException {
        if (!JdbcConnectionModule.areTableInitialized()) {
            JdbcConnectionModule.initTables(connectionSource);
        }
        return DaoManager.createDao((ConnectionSource)connectionSource, RunStatus.class);
    }

    @Provides
    @Singleton
    public Dao<TaskStatus, Long> getTaskStatusDao(ConnectionSource connectionSource) throws SQLException {
        if (!JdbcConnectionModule.areTableInitialized()) {
            JdbcConnectionModule.initTables(connectionSource);
        }
        return DaoManager.createDao((ConnectionSource)connectionSource, TaskStatus.class);
    }
}

