/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.model;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import it.netgrid.lovelace.Configuration;
import it.netgrid.lovelace.model.RunStatus;
import it.netgrid.lovelace.model.SchedulerStatus;
import it.netgrid.lovelace.model.StepStatus;
import it.netgrid.lovelace.model.TaskStatus;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(JdbcConnectionModule.class);
    private static boolean tablesInitialized = false;

    protected void configure() {
    }

    @Provides
    @Singleton
    public ConnectionSource getConnection(Configuration configuration) throws SQLException {
        JdbcPooledConnectionSource retval = new JdbcPooledConnectionSource(configuration.getJdbcConnectionUrl(), configuration.getJdbcUsername(), configuration.getJdbcPassword());
        JdbcConnectionModule.initTables((ConnectionSource)retval);
        return retval;
    }

    public static final void initTables(ConnectionSource connection) {
        tablesInitialized = true;
        try {
            TableUtils.createTableIfNotExists((ConnectionSource)connection, SchedulerStatus.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connection, TaskStatus.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connection, StepStatus.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connection, RunStatus.class);
        }
        catch (SQLException e) {
            log.warn("SQL errors during DB creation");
            log.debug("SQL errors during DB creation:", (Throwable)e);
        }
    }

    public static final boolean areTableInitialized() {
        return tablesInitialized;
    }
}

