/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.quartz;

import com.google.inject.Injector;
import javax.inject.Inject;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public final class GuiceJobFactory
implements JobFactory {
    private final Injector guice;

    @Inject
    public GuiceJobFactory(Injector guice) {
        this.guice = guice;
    }

    public Job newJob(TriggerFiredBundle triggerFiredBundle, Scheduler scheduler) throws SchedulerException {
        JobDetail jobDetail = triggerFiredBundle.getJobDetail();
        Class jobClass = jobDetail.getJobClass();
        try {
            return (Job)this.guice.getInstance(jobClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }
}

