/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.quartz;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.netgrid.commons.data.CrudObject;
import it.netgrid.commons.data.CrudService;
import it.netgrid.lovelace.Configuration;
import it.netgrid.lovelace.model.SchedulerStatus;
import java.sql.SQLException;
import java.util.Date;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LovelaceSchedulerListener
implements SchedulerListener {
    private static final Logger log = LoggerFactory.getLogger(LovelaceSchedulerListener.class);
    private final CrudService<SchedulerStatus, Long> schedulerStatusService;
    private final Configuration config;

    @Inject
    public LovelaceSchedulerListener(Configuration config, CrudService<SchedulerStatus, Long> schedulerStatusService) {
        this.schedulerStatusService = schedulerStatusService;
        this.config = config;
    }

    public void jobScheduled(Trigger trigger) {
    }

    public void jobUnscheduled(TriggerKey triggerKey) {
    }

    public void triggerFinalized(Trigger trigger) {
    }

    public void triggerPaused(TriggerKey triggerKey) {
    }

    public void triggersPaused(String triggerGroup) {
    }

    public void triggerResumed(TriggerKey triggerKey) {
    }

    public void triggersResumed(String triggerGroup) {
    }

    public void jobAdded(JobDetail jobDetail) {
    }

    public void jobDeleted(JobKey jobKey) {
    }

    public void jobPaused(JobKey jobKey) {
    }

    public void jobsPaused(String jobGroup) {
    }

    public void jobResumed(JobKey jobKey) {
    }

    public void jobsResumed(String jobGroup) {
    }

    public void schedulerError(String msg, SchedulerException cause) {
    }

    public void schedulerInStandbyMode() {
    }

    public void schedulerStarted() {
        try {
            SchedulerStatus status = (SchedulerStatus)this.schedulerStatusService.read((Object)this.config.getSchedulerId());
            status.setActiveFrom(new Date());
            this.schedulerStatusService.update((CrudObject)status);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to update scheduler status");
        }
        catch (SQLException e) {
            log.error("Unable to update scheduler status");
        }
    }

    public void schedulerStarting() {
    }

    public void schedulerShutdown() {
    }

    public void schedulerShuttingdown() {
    }

    public void schedulingDataCleared() {
    }
}

