/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.rest;

import com.google.inject.Inject;
import it.netgrid.commons.data.BulkService;
import it.netgrid.commons.data.CrudService;
import it.netgrid.lovelace.model.TaskStatus;
import it.netgrid.lovelace.quartz.SchedulerUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/search")
public class SearchStatusResource {
    private final CrudService<TaskStatus, Long> taskStatusService;
    private final BulkService<TaskStatus, Long> taskStatusBulk;
    private final SchedulerUtils schedulerUtils;

    @Inject
    public SearchStatusResource(BulkService<TaskStatus, Long> taskStatusBulk, SchedulerUtils schedulerUtils, CrudService<TaskStatus, Long> taskStatusService) {
        this.taskStatusBulk = taskStatusBulk;
        this.taskStatusService = taskStatusService;
        this.schedulerUtils = schedulerUtils;
    }

    @GET
    @Path(value="{query}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public List<TaskStatus> query(@PathParam(value="query") String query) throws IllegalArgumentException, SQLException {
        return this.readTaskStatus(query);
    }

    @POST
    @Path(value="{query}/run")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public List<TaskStatus> manualStart(@PathParam(value="query") String query) throws IllegalArgumentException, SQLException {
        List<TaskStatus> tasks = this.readTaskStatus(query);
        ArrayList<TaskStatus> retval = new ArrayList<TaskStatus>();
        for (TaskStatus task : tasks) {
            this.schedulerUtils.runNow(task);
            retval.add((TaskStatus)this.taskStatusService.read((Object)task.getId()));
        }
        return retval;
    }

    @DELETE
    @Path(value="{query}/run")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public List<TaskStatus> manualStop(@PathParam(value="query") String query) throws IllegalArgumentException, SQLException {
        List<TaskStatus> tasks = this.readTaskStatus(query);
        ArrayList<TaskStatus> retval = new ArrayList<TaskStatus>();
        for (TaskStatus task : tasks) {
            this.schedulerUtils.stopNow(task);
            retval.add((TaskStatus)this.taskStatusService.read((Object)task.getId()));
        }
        return retval;
    }

    private List<TaskStatus> readTaskStatus(String name) throws IllegalArgumentException, SQLException {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("tsk_name", name);
        List result = this.taskStatusBulk.read(filter, Long.valueOf(1L), null);
        if (result == null) {
            return new ArrayList<TaskStatus>();
        }
        return result;
    }
}

