/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.rest;

import com.google.inject.Inject;
import it.netgrid.commons.data.CrudObject;
import it.netgrid.commons.data.CrudService;
import it.netgrid.lovelace.Configuration;
import it.netgrid.lovelace.model.RunStatus;
import it.netgrid.lovelace.model.SchedulerStatus;
import it.netgrid.lovelace.model.StepStatus;
import it.netgrid.lovelace.model.TaskStatus;
import it.netgrid.lovelace.quartz.SchedulerUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/tasks")
public class TaskStatusResource {
    public static final String INVALID_TASK = "task/id";
    private final CrudService<TaskStatus, Long> taskStatusService;
    private final CrudService<RunStatus, Long> runStatusService;
    private final CrudService<SchedulerStatus, Long> schedulerStatusService;
    private final SchedulerUtils schedulerUtils;
    private final Configuration config;

    @Inject
    public TaskStatusResource(Configuration config, CrudService<TaskStatus, Long> taskStatusService, SchedulerUtils schedulerUtils, CrudService<SchedulerStatus, Long> schedulerStatusService, CrudService<RunStatus, Long> runStatusService) {
        this.config = config;
        this.taskStatusService = taskStatusService;
        this.schedulerUtils = schedulerUtils;
        this.runStatusService = runStatusService;
        this.schedulerStatusService = schedulerStatusService;
    }

    @GET
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public List<TaskStatus> getTasks() throws IllegalArgumentException, SQLException {
        SchedulerStatus system = (SchedulerStatus)this.schedulerStatusService.read((Object)this.config.getSchedulerId());
        return system.getTasks();
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public TaskStatus createTask(TaskStatus task) throws IllegalArgumentException, SQLException {
        this.taskStatusService.create((CrudObject)task);
        TaskStatus retval = (TaskStatus)this.taskStatusService.read((Object)task.getId());
        return retval;
    }

    @GET
    @Path(value="{task}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public TaskStatus getTask(@PathParam(value="task") Long taskId) throws IllegalArgumentException, SQLException {
        TaskStatus retval = (TaskStatus)this.taskStatusService.read((Object)taskId);
        return retval;
    }

    @PUT
    @Path(value="{task}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public TaskStatus updateTask(@PathParam(value="task") Long taskId, TaskStatus task) throws IllegalArgumentException, SQLException {
        task.setId(taskId);
        this.taskStatusService.update((CrudObject)task);
        TaskStatus retval = (TaskStatus)this.taskStatusService.read((Object)task.getId());
        return retval;
    }

    @DELETE
    @Path(value="{task}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public TaskStatus deleteTask(@PathParam(value="task") Long taskId) throws IllegalArgumentException, SQLException {
        TaskStatus task = (TaskStatus)this.taskStatusService.read((Object)taskId);
        this.taskStatusService.delete((CrudObject)task);
        return task;
    }

    @POST
    @Path(value="{task}/run")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public TaskStatus manualStart(@PathParam(value="task") Long taskId) throws IllegalArgumentException, SQLException {
        TaskStatus task = (TaskStatus)this.taskStatusService.read((Object)taskId);
        this.schedulerUtils.runNow(task);
        task = (TaskStatus)this.taskStatusService.read((Object)taskId);
        return task;
    }

    @DELETE
    @Path(value="{task}/run")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public TaskStatus manualStop(@PathParam(value="task") Long taskId) throws IllegalArgumentException, SQLException {
        TaskStatus task = (TaskStatus)this.taskStatusService.read((Object)taskId);
        this.schedulerUtils.stopNow(task);
        task = (TaskStatus)this.taskStatusService.read((Object)taskId);
        return task;
    }

    @GET
    @Path(value="{task}/runs")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public List<RunStatus> getTaskRuns(@PathParam(value="task") Long taskId) throws IllegalArgumentException, SQLException {
        TaskStatus task = (TaskStatus)this.taskStatusService.read((Object)taskId);
        ArrayList<RunStatus> retval = new ArrayList<RunStatus>();
        for (RunStatus run : task.getTaskRuns()) {
            retval.add(run);
        }
        return retval;
    }

    @GET
    @Path(value="{task}/runs/{run}/steps")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public List<StepStatus> getRunSteps(@PathParam(value="task") Long taskId, @PathParam(value="run") Long run) throws IllegalArgumentException, SQLException {
        ArrayList<StepStatus> retval = new ArrayList<StepStatus>();
        RunStatus runStatus = (RunStatus)this.runStatusService.read((Object)run);
        if (runStatus.getTaskStatus().getId() != taskId) {
            throw new IllegalArgumentException(INVALID_TASK);
        }
        for (StepStatus step : runStatus.getStepsStatus()) {
            retval.add(step);
        }
        return retval;
    }
}

