/*
 * Decompiled with CFR 0.152.
 */
package it.netgrid.lovelace.tasks;

import com.google.inject.Inject;
import it.netgrid.lovelace.Task;
import it.netgrid.lovelace.api.StepService;
import it.netgrid.lovelace.model.ExecutionResult;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public class SleepingTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(SleepingTask.class);
    private static final int DEFAULT_SLEEP_MILLIS = 2000;
    public static final String SLEEP_MILLIS_FIELD_NAME = "sleep_millis";
    private final StepService runStatus;

    public SleepingTask() {
        this.runStatus = null;
    }

    @Inject
    public SleepingTask(StepService runStatus) {
        this.runStatus = runStatus;
    }

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        try {
            int millis = this.getSleepMillis(arg0);
            Thread.sleep(millis);
            this.runStatus.nextStep(arg0, ExecutionResult.SUCCESS, "slept");
            log.info("Slept for " + millis);
        }
        catch (InterruptedException e) {
            log.debug("Sleep interrupt", (Throwable)e);
        }
    }

    @Override
    public String getFirstStepName() {
        return "going to sleep";
    }

    @Override
    public int getStepsCount() {
        return 2;
    }

    private int getSleepMillis(JobExecutionContext context) {
        try {
            String millis = context.getJobDetail().getJobDataMap().getString(SLEEP_MILLIS_FIELD_NAME);
            return Integer.parseInt(millis);
        }
        catch (Exception e) {
            return 2000;
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        log.debug("Job interrupt");
    }
}

