/*
 * Decompiled with CFR 0.152.
 */
package it.nicolasfarabegoli.gradle;

import it.nicolasfarabegoli.gradle.ConventionalCommitScriptKt;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a@\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002\u001aX\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0019\u001a\u00020\u0018*\u00020\u0016H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u00a8\u0006\u001b"}, d2={"createCommitMessage", "", "types", "", "scopes", "successMessage", "failureMessage", "ignoreMessageCommit", "escapeChar", "c", "", "str", "escapeChars", "cs", "escapeNewlines", "sanitize", "wrapInEcho", "writeScript", "", "project", "Lorg/gradle/api/Project;", "baseDir", "Ljava/io/File;", "warningIfNoGitRoot", "", "isGitFolder", "content", "conventional-commits"})
@SourceDebugExtension(value={"SMAP\nConventionalCommitScript.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConventionalCommitScript.kt\nit/nicolasfarabegoli/gradle/ConventionalCommitScriptKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,91:1\n1#2:92\n1819#3,8:93\n12474#4,2:101\n*S KotlinDebug\n*F\n+ 1 ConventionalCommitScript.kt\nit/nicolasfarabegoli/gradle/ConventionalCommitScriptKt\n*L\n81#1:93,8\n85#1:101,2\n*E\n"})
public final class ConventionalCommitScriptKt {
    public static final void writeScript(@NotNull Project project, @NotNull File baseDir, @NotNull List<String> types, @NotNull List<String> scopes, boolean warningIfNoGitRoot, @Nullable String successMessage, @Nullable String failureMessage, @NotNull String ignoreMessageCommit) {
        block6: {
            Unit unit;
            Object v0;
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
                Intrinsics.checkNotNullParameter(types, (String)"types");
                Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
                Intrinsics.checkNotNullParameter((Object)ignoreMessageCommit, (String)"ignoreMessageCommit");
                project.getLogger().debug("Finding the '.git' folder");
                Sequence sequence = SequencesKt.generateSequence((Object)baseDir, (Function1)writeScript.1.INSTANCE);
                for (Object e : sequence) {
                    File it = (File)e;
                    boolean bl = false;
                    if (!ConventionalCommitScriptKt.isGitFolder(it)) continue;
                    v0 = e;
                    break block5;
                }
                v0 = null;
            }
            File file = v0;
            if (file != null) {
                File it = file;
                boolean bl = false;
                String scriptContent = ConventionalCommitScriptKt.createCommitMessage(types, scopes, successMessage, failureMessage, ignoreMessageCommit);
                File hooksFolder = FilesKt.resolve((File)it, (String)".git/hooks/");
                if (!hooksFolder.exists()) {
                    hooksFolder.mkdir();
                }
                ConventionalCommitScriptKt.writeScript(FilesKt.resolve((File)it, (String)".git/hooks/commit-msg"), scriptContent);
                project.getLogger().debug("[ConventionalCommits] script file written in '.git/hooks/commit-msg'");
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block6;
            boolean bl = false;
            project.getLogger().debug("[ConventionalCommits] '.git' folder not found. No action taken");
            if (warningIfNoGitRoot) {
                project.getLogger().warn("[ConventionalCommits] Not '.git' root found! No script will be generated");
            }
        }
    }

    private static final String createCommitMessage(List<String> types, List<String> scopes, String successMessage, String failureMessage, String ignoreMessageCommit) {
        String typesRegex = CollectionsKt.joinToString$default((Iterable)types, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
        String scopesRegex = scopes.isEmpty() ? "[a-z \\-]+" : CollectionsKt.joinToString$default((Iterable)scopes, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
        String successMessageEcho = ConventionalCommitScriptKt.wrapInEcho(successMessage);
        String failureMessageEcho = ConventionalCommitScriptKt.wrapInEcho(failureMessage);
        return StringsKt.trimIndent((String)("\n        #!/usr/bin/env bash\n        \n        # Regex for conventional commits\n        conventional_commits_regex=\"^(" + typesRegex + ")(\\((" + scopesRegex + ")\\))?\\!?:\\ .+$\"\n        \n        # Regex used to exclude message commit that match this regex\n        exclude=\"" + ignoreMessageCommit + "\"\n        \n        # Get the commit message (the parameter we're given is just the path to the\n        # temporary file which holds the message).\n        commit_message=$(cat \"$1\")\n        \n        # Check if the message math the exclude regex, if so, all good baby.\n        if [[ \"$commit_message\" =~ $exclude ]]; then\n            " + successMessageEcho + "\n            exit 0\n        fi\n        \n        # Check the message, if we match, all good baby.\n        if [[ \"$commit_message\" =~ $conventional_commits_regex ]]; then\n           " + successMessageEcho + "\n           exit 0\n        fi\n        \n        # Uh-oh, this is not a conventional commit, show an example and link to the spec.\n        " + failureMessageEcho + "\n        exit 1\n    "));
    }

    private static final String wrapInEcho(String str) {
        String string;
        block3: {
            block2: {
                string = str;
                if (string == null) break block2;
                String s = string;
                boolean bl = false;
                String string2 = "echo -e '" + ConventionalCommitScriptKt.sanitize(s) + '\'';
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        return string;
    }

    private static final String sanitize(String str) {
        List charsToEscape = CollectionsKt.listOf((Object)Character.valueOf('\''));
        String escaped = ConventionalCommitScriptKt.escapeNewlines(str);
        return ConventionalCommitScriptKt.escapeChars(escaped, charsToEscape);
    }

    private static final String escapeChar(char c, String str) {
        String string = String.valueOf(c);
        String string2 = "\\x%x";
        Object[] objectArray = new Object[]{(int)c};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        return StringsKt.replace$default((String)str, (String)string, (String)string3, (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String escapeChars(String str, List<Character> cs) {
        List<Character> $this$foldRight$iv = cs;
        boolean $i$f$foldRight = false;
        String accumulator$iv = str;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator<Character> iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void p1;
                String string = accumulator$iv;
                char p0 = iterator$iv.previous().charValue();
                boolean bl = false;
                accumulator$iv = ConventionalCommitScriptKt.escapeChar(p0, (String)p1);
            }
        }
        return accumulator$iv;
    }

    private static final String escapeNewlines(String str) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)str, (String)"\r", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"'", (String)"\\'", (boolean)false, (int)4, null);
    }

    private static final boolean isGitFolder(File $this$isGitFolder) {
        boolean bl;
        block3: {
            File[] fileArray = $this$isGitFolder.listFiles();
            if (fileArray != null) {
                File[] $this$any$iv = fileArray;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File folder = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!(folder.isDirectory() && Intrinsics.areEqual((Object)folder.getName(), (Object)".git"))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private static final void writeScript(File $this$writeScript, String content) {
        FilesKt.writeText$default((File)$this$writeScript, (String)content, null, (int)2, null);
        $this$writeScript.setExecutable(true);
    }
}

