/*
 * Decompiled with CFR 0.152.
 */
package it.nicolasfarabegoli.gradle;

import com.github.ajalt.mordant.rendering.TextColors;
import it.nicolasfarabegoli.gradle.ConventionalCommitScriptKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lit/nicolasfarabegoli/gradle/ConventionalCommitsExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "failureMessage", "", "getFailureMessage", "()Ljava/lang/String;", "setFailureMessage", "(Ljava/lang/String;)V", "ignoreCommitMessage", "getIgnoreCommitMessage", "setIgnoreCommitMessage", "scopes", "", "getScopes", "()Ljava/util/List;", "setScopes", "(Ljava/util/List;)V", "successMessage", "getSuccessMessage", "setSuccessMessage", "types", "getTypes", "setTypes", "warningIfNoGitRoot", "", "getWarningIfNoGitRoot", "()Z", "setWarningIfNoGitRoot", "(Z)V", "setupScript", "", "setupScript$conventional_commits", "conventional-commits"})
public class ConventionalCommitsExtension {
    @NotNull
    private final Project project;
    private boolean warningIfNoGitRoot;
    @NotNull
    private List<String> types;
    @NotNull
    private List<String> scopes;
    @Nullable
    private String successMessage;
    @Nullable
    private String failureMessage;
    @NotNull
    private String ignoreCommitMessage;

    public ConventionalCommitsExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.warningIfNoGitRoot = true;
        Object[] objectArray = new String[]{"build", "chore", "ci", "docs", "feat", "fix", "perf", "refactor", "revert", "style", "test"};
        this.types = CollectionsKt.listOf((Object[])objectArray);
        this.scopes = CollectionsKt.emptyList();
        this.successMessage = TextColors.green.invoke("Commit message meets Conventional Commit standards...");
        this.failureMessage = StringsKt.trimIndent((String)("\n        " + TextColors.red.invoke("The commit message does not meet the Conventional Commit standard") + "\n        An example of a valid message is: \n          feat(login): add the remember me button\n        More details at: https://www.conventionalcommits.org/en/v1.0.0/#summary\n    "));
        this.ignoreCommitMessage = ".^";
    }

    public final boolean getWarningIfNoGitRoot() {
        return this.warningIfNoGitRoot;
    }

    public final void setWarningIfNoGitRoot(boolean bl) {
        this.warningIfNoGitRoot = bl;
    }

    @NotNull
    public final List<String> getTypes() {
        return this.types;
    }

    public final void setTypes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.types = list;
    }

    @NotNull
    public final List<String> getScopes() {
        return this.scopes;
    }

    public final void setScopes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.scopes = list;
    }

    @Nullable
    public final String getSuccessMessage() {
        return this.successMessage;
    }

    public final void setSuccessMessage(@Nullable String string) {
        this.successMessage = string;
    }

    @Nullable
    public final String getFailureMessage() {
        return this.failureMessage;
    }

    public final void setFailureMessage(@Nullable String string) {
        this.failureMessage = string;
    }

    @NotNull
    public final String getIgnoreCommitMessage() {
        return this.ignoreCommitMessage;
    }

    public final void setIgnoreCommitMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ignoreCommitMessage = string;
    }

    public final void setupScript$conventional_commits() {
        File file = this.project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getProjectDir(...)");
        ConventionalCommitScriptKt.writeScript(this.project, file, this.types, this.scopes, this.warningIfNoGitRoot, this.successMessage, this.failureMessage, this.ignoreCommitMessage);
    }
}

