/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.templating.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import freemarker.template.Configuration;
import freemarker.template.Template;
import it.ozimov.springboot.mail.service.TemplateService;
import it.ozimov.springboot.mail.service.exception.TemplateException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class FreemarkerTemplateService
implements TemplateService {
    @Autowired
    private Configuration freemarkerConfiguration;

    @NonNull
    public String mergeTemplateIntoString(@NonNull String templateReference, @NonNull Map<String, Object> model) throws IOException, TemplateException {
        if (templateReference == null) {
            throw new NullPointerException("templateReference");
        }
        if (model == null) {
            throw new NullPointerException("model");
        }
        String trimmedTemplateReference = templateReference.trim();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)trimmedTemplateReference) ? 1 : 0) != 0, (Object)"The given template is null, empty or blank");
        if (trimmedTemplateReference.contains(".")) {
            Preconditions.checkArgument((boolean)Objects.equals(Files.getFileExtension((String)trimmedTemplateReference), this.expectedTemplateExtension()), (String)"Expected a Freemarker template file with extension 'ftl', while '%s' was given", (Object)Files.getFileExtension((String)trimmedTemplateReference));
        }
        try {
            String normalizedTemplateReference = trimmedTemplateReference.endsWith(this.expectedTemplateExtension()) ? trimmedTemplateReference : trimmedTemplateReference + '.' + this.expectedTemplateExtension();
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)this.freemarkerConfiguration.getTemplate(normalizedTemplateReference, Charset.forName("UTF-8").name()), model);
        }
        catch (Exception e) {
            throw new TemplateException((Throwable)e);
        }
    }

    public String expectedTemplateExtension() {
        return "ftl";
    }
}

