/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import it.polimi.spf.lib.SPFPermissionManager;
import it.polimi.spf.shared.SPFInfo;
import it.polimi.spf.shared.aidl.SPFAppRegistrationCallback;
import it.polimi.spf.shared.aidl.SPFSecurityService;
import it.polimi.spf.shared.model.AppDescriptor;
import it.polimi.spf.shared.model.SPFError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

class AccessTokenManager {
    private static final String TOKEN_FILE_NAME = "accesstoken";
    private static final String TAG = "AccessTokenManager";
    private static AccessTokenManager sSingleton;
    private String mToken;
    private volatile boolean isWaitingForResponse = false;
    private final List<RegistrationCallback> mPendingRequests = new ArrayList<RegistrationCallback>();
    private Context mContext;
    private SPFAppRegistrationCallback.Stub mServiceCallback = new SPFAppRegistrationCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationSuccess(String accessToken) throws RemoteException {
            List list = AccessTokenManager.this.mPendingRequests;
            synchronized (list) {
                AccessTokenManager.this.setToken(accessToken);
                AccessTokenManager.this.isWaitingForResponse = false;
            }
            for (RegistrationCallback callback : AccessTokenManager.this.mPendingRequests) {
                callback.onRegistrationSuccessful();
            }
            Log.d((String)AccessTokenManager.TAG, (String)("Registration successful. " + AccessTokenManager.this.mPendingRequests.size() + " pending callbacks notified"));
            AccessTokenManager.this.mPendingRequests.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegistrationFailure() throws RemoteException {
            List list = AccessTokenManager.this.mPendingRequests;
            synchronized (list) {
                AccessTokenManager.this.isWaitingForResponse = false;
            }
            for (RegistrationCallback callback : AccessTokenManager.this.mPendingRequests) {
                callback.onRegistrationError(new SPFError(7));
            }
            Log.d((String)AccessTokenManager.TAG, (String)("Registration failed. " + AccessTokenManager.this.mPendingRequests.size() + " pending callbacks notified"));
            AccessTokenManager.this.mPendingRequests.clear();
        }
    };

    public static synchronized AccessTokenManager get(Context context) {
        if (sSingleton == null) {
            File f = new File(context.getFilesDir(), TOKEN_FILE_NAME);
            String token = null;
            try {
                if (!f.exists()) {
                    f.createNewFile();
                } else {
                    BufferedReader reader = new BufferedReader(new FileReader(f));
                    token = reader.readLine();
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"IO Exception reading token file");
            }
            Log.d((String)TAG, (String)(token == null ? "Token not available" : "Token loaded from file"));
            sSingleton = new AccessTokenManager(context, token);
        }
        return sSingleton;
    }

    private AccessTokenManager(Context context, String token) {
        this.mContext = context;
        this.mToken = token;
    }

    public String getAccessToken() {
        return this.mToken;
    }

    public boolean hasToken() {
        return this.mToken != null;
    }

    private void setToken(String token) {
        this.mToken = token;
        File f = new File(this.mContext.getFilesDir(), TOKEN_FILE_NAME);
        if (token == null) {
            f.delete();
            Log.d((String)TAG, (String)"Token deleted");
        } else {
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(f, false));
                writer.println(token);
                writer.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error saving token to file accesstoken", (Throwable)e);
            }
            Log.d((String)TAG, (String)"Token saved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requireAccessToken(final Context context, final RegistrationCallback callback) {
        List<RegistrationCallback> list = this.mPendingRequests;
        synchronized (list) {
            if (this.hasToken()) {
                callback.onRegistrationSuccessful();
                return;
            }
            this.mPendingRequests.add(callback);
            if (this.isWaitingForResponse) {
                return;
            }
            this.isWaitingForResponse = true;
        }
        Intent i = new Intent();
        i.setComponent(SPFInfo.getSPFServiceComponentName());
        i.setAction("it.polimi.spf.framework.local.SecurityService");
        boolean bound = context.bindService(i, new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
            }

            public void onServiceConnected(ComponentName name, IBinder binder) {
                SPFSecurityService service = SPFSecurityService.Stub.asInterface((IBinder)binder);
                try {
                    service.registerApp(AccessTokenManager.this.getAppDescriptor(context), (SPFAppRegistrationCallback)AccessTokenManager.this.mServiceCallback);
                }
                catch (RemoteException e) {
                    callback.onRegistrationError(new SPFError(8));
                }
                context.unbindService((ServiceConnection)this);
            }
        }, 1);
        List<RegistrationCallback> list2 = this.mPendingRequests;
        synchronized (list2) {
            if (!bound) {
                callback.onRegistrationError(new SPFError(9));
            }
        }
    }

    private AppDescriptor getAppDescriptor(Context context) {
        String identifier = context.getPackageName();
        try {
            String appVersion = context.getPackageManager().getPackageInfo((String)identifier, (int)0).versionName;
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(identifier, 0);
            String appName = context.getPackageManager().getApplicationLabel(appInfo).toString();
            return new AppDescriptor(identifier, appName, appVersion, SPFPermissionManager.get().getRequiredPermission());
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateToken() {
        List<RegistrationCallback> list = this.mPendingRequests;
        synchronized (list) {
            if (!this.hasToken()) {
                return;
            }
            this.setToken(null);
            this.isWaitingForResponse = false;
        }
    }

    public static interface RegistrationCallback {
        public void onRegistrationSuccessful();

        public void onRegistrationError(SPFError var1);
    }
}

