/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.util.Log;
import it.polimi.spf.lib.AccessTokenManager;
import it.polimi.spf.lib.Utils;
import it.polimi.spf.shared.SPFInfo;
import it.polimi.spf.shared.model.SPFError;

public abstract class Component<C extends Component<C, I>, I extends IInterface> {
    private I mServiceInterface;
    private Context mContext;
    private ServiceConnection mConnection;
    private ConnectionCallback<C> mCallback;

    protected static <C extends Component<C, I>, I extends IInterface> void load(final Context context, final Descriptor<C, I> descriptor, final ConnectionCallback<C> callback) {
        Utils.notNull(context, "context must not be null");
        Utils.notNull(descriptor, "context must not be null");
        if (AccessTokenManager.get(context).hasToken()) {
            Component.bindToService(context, descriptor, callback);
        } else {
            AccessTokenManager.get(context).requireAccessToken(context, new AccessTokenManager.RegistrationCallback(){

                @Override
                public void onRegistrationSuccessful() {
                    Log.d((String)"Component", (String)("Access Toekn: " + descriptor));
                    Component.bindToService(context, descriptor, callback);
                }

                @Override
                public void onRegistrationError(SPFError errorMsg) {
                    callback.onError(errorMsg);
                }
            });
        }
    }

    private static <C extends Component<C, I>, I extends IInterface> void bindToService(final Context context, final Descriptor<C, I> descriptor, final ConnectionCallback<C> callback) {
        Intent intent = new Intent();
        intent.setComponent(SPFInfo.getSPFServiceComponentName());
        intent.setAction(descriptor.getActionName());
        ServiceConnection connection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder binder) {
                Object service = descriptor.castInterface(binder);
                Object instance = descriptor.createInstance(context, service, this, callback);
                callback.onServiceReady(instance);
            }

            public void onServiceDisconnected(ComponentName name) {
                callback.onDisconnect();
            }
        };
        if (!context.bindService(intent, connection, 1)) {
            callback.onError(new SPFError(9));
        }
    }

    protected Component(Context context, I serviceInterface, ServiceConnection connection, ConnectionCallback<C> callback) {
        this.mServiceInterface = serviceInterface;
        this.mContext = context;
        this.mConnection = connection;
        this.mCallback = callback;
    }

    public void disconnect() {
        try {
            this.mContext.unbindService(this.mConnection);
        }
        catch (Exception e) {
            Log.w((String)this.getClass().getSimpleName(), (String)"Exception unbinding from service: ", (Throwable)e);
        }
    }

    protected ConnectionCallback<C> getCallback() {
        return this.mCallback;
    }

    protected I getService() {
        return this.mServiceInterface;
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected String getAccessToken() {
        return AccessTokenManager.get(this.getContext()).getAccessToken();
    }

    protected void handleError(SPFError err) {
        if (err.codeEquals(1)) {
            AccessTokenManager.get(this.mContext).invalidateToken();
        }
        this.mCallback.onError(err);
    }

    protected static interface Descriptor<C extends Component<C, I>, I extends IInterface> {
        public String getActionName();

        public I castInterface(IBinder var1);

        public C createInstance(Context var1, I var2, ServiceConnection var3, ConnectionCallback<C> var4);
    }

    protected static interface ConnectionCallback<C extends Component<C, ?>> {
        public void onServiceReady(C var1);

        public void onError(SPFError var1);

        public void onDisconnect();
    }
}

