/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import it.polimi.spf.lib.Utils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class LooperUtils {
    public static <E> E onMainThread(Class<E> callbackInterface, final E callback) {
        Utils.notNull(callbackInterface, "callbackInterface must not be null");
        Utils.notNull(callback, "callback must not be null");
        final Handler handler = new Handler(Looper.getMainLooper());
        final String tag = callback.getClass().getSimpleName();
        Object proxy = Proxy.newProxyInstance(callbackInterface.getClassLoader(), new Class[]{callbackInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            method.invoke(callback, args);
                        }
                        catch (IllegalAccessException e) {
                            Log.e((String)tag, (String)("Error executing method " + method.getName() + " on main thread."), (Throwable)e);
                        }
                        catch (IllegalArgumentException e) {
                            Log.e((String)tag, (String)("Error executing method " + method.getName() + " on main thread."), (Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            Log.e((String)tag, (String)("Error executing method " + method.getName() + " on main thread."), (Throwable)e);
                        }
                    }
                });
                return null;
            }
        });
        return callbackInterface.cast(proxy);
    }
}

