/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib;

import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import it.polimi.spf.lib.Component;
import it.polimi.spf.lib.profile.SPFRemoteProfile;
import it.polimi.spf.lib.search.SPFSearch;
import it.polimi.spf.lib.services.SPFServiceExecutor;
import it.polimi.spf.lib.services.ServiceInvocationException;
import it.polimi.spf.shared.aidl.SPFProximityService;
import it.polimi.spf.shared.aidl.SPFSearchCallback;
import it.polimi.spf.shared.model.InvocationRequest;
import it.polimi.spf.shared.model.InvocationResponse;
import it.polimi.spf.shared.model.ProfileFieldContainer;
import it.polimi.spf.shared.model.SPFActivity;
import it.polimi.spf.shared.model.SPFError;
import it.polimi.spf.shared.model.SPFSearchDescriptor;

public class SPF
extends Component<SPF, SPFProximityService> {
    public static final int SEARCH = 0;
    public static final int SERVICE_EXECUTION = 1;
    public static final int REMOTE_PROFILE = 2;
    private static final String TAG = "SPF";
    public static SPF instance = null;
    private static final Component.Descriptor<SPF, SPFProximityService> DESCRIPTOR = new Component.Descriptor<SPF, SPFProximityService>(){

        @Override
        public String getActionName() {
            return "it.polimi.spf.framework.local.SPFServerService";
        }

        @Override
        public SPFProximityService castInterface(IBinder binder) {
            return SPFProximityService.Stub.asInterface((IBinder)binder);
        }

        @Override
        public SPF createInstance(Context context, SPFProximityService serviceInterface, ServiceConnection connection, Component.ConnectionCallback<SPF> callback) {
            instance = new SPF(context, serviceInterface, connection, callback);
            return instance;
        }
    };
    private SPFSearch spfSearch;
    private SPFRemoteProfile spfRemoteProfile;
    private SPFServiceExecutor spfServiceExecutor;

    public static void connect(Context context, ConnectionListener listener) {
        Component.load(context, DESCRIPTOR, SPF.asBase(listener));
    }

    private static Component.ConnectionCallback<SPF> asBase(final ConnectionListener listener) {
        return new Component.ConnectionCallback<SPF>(){

            @Override
            public void onServiceReady(SPF serviceInterface) {
                listener.onConnected(serviceInterface);
            }

            @Override
            public void onError(SPFError err) {
                listener.onError(err);
            }

            @Override
            public void onDisconnect() {
                listener.onDisconnected();
            }
        };
    }

    private SPF(Context context, SPFProximityService serverService, ServiceConnection serviceConnection, Component.ConnectionCallback<SPF> callback) {
        super(context, serverService, serviceConnection, callback);
    }

    public synchronized <E> E getComponent(int code) {
        switch (code) {
            case 2: {
                if (this.spfRemoteProfile == null) {
                    this.spfRemoteProfile = new SPFRemoteProfile(this.getContext(), this);
                }
                return (E)this.spfRemoteProfile;
            }
            case 0: {
                if (this.spfSearch == null) {
                    this.spfSearch = new SPFSearch(this.getContext(), this);
                }
                return (E)this.spfSearch;
            }
            case 1: {
                if (this.spfServiceExecutor == null) {
                    this.spfServiceExecutor = new SPFServiceExecutor(this.getContext(), this);
                }
                return (E)this.spfServiceExecutor;
            }
        }
        throw new IllegalArgumentException("Component code " + code + " not found.");
    }

    @Override
    public void disconnect() {
        if (this.spfSearch != null) {
            this.spfSearch.recycle();
        }
        super.disconnect();
    }

    public void startSearch(SPFSearchDescriptor searchDescriptor, SPFSearchCallback callback) {
        try {
            SPFError err = new SPFError();
            ((SPFProximityService)this.getService()).startNewSearch(this.getAccessToken(), searchDescriptor, callback, err);
            if (!err.isOk()) {
                this.handleError(err);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void stopSearch(String queryId) {
        try {
            SPFError err = new SPFError();
            ((SPFProximityService)this.getService()).stopSearch(this.getAccessToken(), queryId, err);
            if (!err.isOk()) {
                this.handleError(err);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean lookup(String identifier) {
        try {
            SPFError err = new SPFError();
            boolean found = ((SPFProximityService)this.getService()).lookup(this.getAccessToken(), identifier, err);
            if (err.isOk()) {
                return found;
            }
            this.handleError(err);
            return false;
        }
        catch (RemoteException e) {
            Log.d((String)TAG, (String)("Remote exception while executing lookup on " + identifier), (Throwable)e);
            return false;
        }
    }

    public ProfileFieldContainer getProfileBulk(String identifier, String[] fields, SPFError err) {
        String accessToken = this.getAccessToken();
        try {
            ProfileFieldContainer pfc = ((SPFProximityService)this.getService()).getProfileBulk(accessToken, identifier, fields, err);
            if (err.isOk()) {
                return pfc;
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error @ getProfileBulk", (Throwable)e);
        }
        this.handleError(err);
        return null;
    }

    public void injectActivities(String target, Object[] arguments) throws ServiceInvocationException {
        String token = this.getAccessToken();
        SPFError err = new SPFError();
        try {
            for (Object arg : arguments) {
                if (!(arg instanceof SPFActivity)) continue;
                ((SPFProximityService)this.getService()).injectInformationIntoActivity(token, target, (SPFActivity)arg, err);
                if (err.isOk()) continue;
                this.handleError(err);
                throw new ServiceInvocationException();
            }
        }
        catch (RemoteException e) {
            throw new ServiceInvocationException(e);
        }
    }

    public InvocationResponse executeService(String target, InvocationRequest request) {
        String token = this.getAccessToken();
        SPFError err = new SPFError();
        try {
            InvocationResponse response = ((SPFProximityService)this.getService()).executeRemoteService(token, target, request, err);
            if (!err.isOk()) {
                this.handleError(err);
                response = InvocationResponse.error((String)err.toString());
            }
            return response;
        }
        catch (RemoteException e) {
            return InvocationResponse.error((Throwable)e);
        }
    }

    public InvocationResponse sendActivity(String target, SPFActivity activity) {
        InvocationResponse resp;
        String token = this.getAccessToken();
        SPFError err = new SPFError();
        try {
            ((SPFProximityService)this.getService()).injectInformationIntoActivity(token, target, activity, err);
            if (!err.isOk()) {
                this.handleError(err);
                return InvocationResponse.error((String)err.toString());
            }
            resp = ((SPFProximityService)this.getService()).sendActivity(token, target, activity, err);
        }
        catch (RemoteException e) {
            return InvocationResponse.error((Throwable)e);
        }
        if (!err.isOk()) {
            this.handleError(err);
            resp = InvocationResponse.error((String)err.toString());
        }
        return resp;
    }

    public static interface ConnectionListener {
        public void onConnected(SPF var1);

        public void onError(SPFError var1);

        public void onDisconnected();
    }
}

