/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib;

import it.polimi.spf.shared.model.Permission;

public class SPFPermissionManager {
    private static SPFPermissionManager sSingleton;
    private int mRequiredPermissions = 0;

    public static synchronized SPFPermissionManager get() {
        if (sSingleton == null) {
            sSingleton = new SPFPermissionManager();
        }
        return sSingleton;
    }

    public void requirePermission(Permission ... permissions) {
        if (permissions == null) {
            throw new NullPointerException();
        }
        for (Permission p : permissions) {
            if (p == null) {
                throw new NullPointerException();
            }
            this.mRequiredPermissions |= p.getCode();
        }
    }

    public int getRequiredPermission() {
        return this.mRequiredPermissions;
    }
}

