/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib;

import it.polimi.spf.lib.SPF;
import it.polimi.spf.lib.profile.SPFRemoteProfile;
import it.polimi.spf.lib.services.SPFServiceExecutor;
import it.polimi.spf.shared.model.BaseInfo;
import it.polimi.spf.shared.model.SPFActivity;

public class SPFPerson {
    public static final String SELF_IDENTIFIER = "#SELF";
    private String mIdentifier;
    private BaseInfo mBaseInfo;

    public SPFPerson(String uniqueIdentifier) {
        this(uniqueIdentifier, null);
    }

    public SPFPerson(String uniqueIdentifier, BaseInfo baseInfo) {
        this.mIdentifier = uniqueIdentifier != null ? uniqueIdentifier : SELF_IDENTIFIER;
        this.mBaseInfo = baseInfo;
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public BaseInfo getBaseInfo() {
        return this.mBaseInfo;
    }

    public boolean isSelf() {
        return this.mIdentifier.equals(SELF_IDENTIFIER);
    }

    public String toString() {
        return this.getIdentifier();
    }

    public SPFRemoteProfile.RemoteProfile getProfile(SPF spf) {
        SPFRemoteProfile rp = (SPFRemoteProfile)spf.getComponent(2);
        return rp.getProfileOf(this);
    }

    public <E> E getServiceInterface(Class<E> serviceInterface, SPF spf) {
        if (spf == null || serviceInterface == null) {
            throw new NullPointerException();
        }
        return ((SPFServiceExecutor)spf.getComponent(1)).createStub(this, serviceInterface, this.getClass().getClassLoader());
    }

    public boolean sendActivity(SPF spf, SPFActivity activity) {
        SPFServiceExecutor executor = (SPFServiceExecutor)spf.getComponent(1);
        return executor.sendActivity(this.mIdentifier, activity);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SPFPerson)) {
            return false;
        }
        return ((SPFPerson)o).mIdentifier.equals(this.mIdentifier);
    }

    public int hashCode() {
        return this.mIdentifier.hashCode();
    }
}

