/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.notification;

import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import it.polimi.spf.lib.Component;
import it.polimi.spf.shared.aidl.SPFNotificationService;
import it.polimi.spf.shared.model.SPFError;
import it.polimi.spf.shared.model.SPFTrigger;
import java.util.ArrayList;
import java.util.List;

public class SPFNotification
extends Component<SPFNotification, SPFNotificationService> {
    private static final Component.Descriptor<SPFNotification, SPFNotificationService> DESCRIPTOR = new Component.Descriptor<SPFNotification, SPFNotificationService>(){

        @Override
        public String getActionName() {
            return "it.polimi.spf.framework.SPFNotificationService";
        }

        @Override
        public SPFNotificationService castInterface(IBinder binder) {
            return SPFNotificationService.Stub.asInterface((IBinder)binder);
        }

        @Override
        public SPFNotification createInstance(Context context, SPFNotificationService serviceInterface, ServiceConnection connection, Component.ConnectionCallback<SPFNotification> callback) {
            return new SPFNotification(context, serviceInterface, connection, callback);
        }
    };

    protected SPFNotification(Context context, SPFNotificationService serviceInterface, ServiceConnection connection, Component.ConnectionCallback<SPFNotification> callback) {
        super(context, serviceInterface, connection, callback);
    }

    public static void load(Context context, Callback callback) {
        Component.load(context, DESCRIPTOR, callback);
    }

    public List<SPFTrigger> listTrigger() {
        try {
            SPFError err = new SPFError(0);
            List trgs = ((SPFNotificationService)this.getService()).listTrigger(this.getAccessToken(), err);
            if (!err.codeEquals(0)) {
                this.handleError(err);
            }
            return trgs;
        }
        catch (RemoteException e) {
            this.catchRemoteException(e);
            return new ArrayList<SPFTrigger>(0);
        }
    }

    public SPFTrigger getTrigger(long triggerId) {
        try {
            SPFError err = new SPFError(0);
            SPFTrigger trg = ((SPFNotificationService)this.getService()).getTrigger(triggerId, this.getAccessToken(), err);
            if (!err.codeEquals(0)) {
                this.handleError(err);
            }
            return trg;
        }
        catch (RemoteException e) {
            this.catchRemoteException(e);
            return null;
        }
    }

    public boolean saveTrigger(SPFTrigger trigger) {
        long newId = trigger.getId();
        try {
            SPFError err = new SPFError(0);
            newId = ((SPFNotificationService)this.getService()).saveTrigger(trigger, this.getAccessToken(), err);
            if (!err.codeEquals(0)) {
                this.handleError(err);
            } else if (newId != -1L) {
                trigger.setId(newId);
                return true;
            }
        }
        catch (RemoteException e) {
            this.catchRemoteException(e);
        }
        return false;
    }

    public boolean deleteTrigger(long triggerId) {
        try {
            SPFError err = new SPFError(0);
            boolean result = ((SPFNotificationService)this.getService()).deleteTrigger(triggerId, this.getAccessToken(), err);
            if (!err.codeEquals(0)) {
                this.handleError(err);
            }
            return result;
        }
        catch (RemoteException e) {
            this.catchRemoteException(e);
            return false;
        }
    }

    public boolean deleteAllTrigger() {
        try {
            SPFError err = new SPFError(0);
            boolean res = ((SPFNotificationService)this.getService()).deleteAllTrigger(this.getAccessToken(), err);
            if (!err.codeEquals(0)) {
                this.handleError(err);
            }
            return res;
        }
        catch (RemoteException e) {
            this.catchRemoteException(e);
            return false;
        }
    }

    private void catchRemoteException(RemoteException e) {
        this.disconnect();
        this.getCallback().onDisconnect();
    }

    public static interface Callback
    extends Component.ConnectionCallback<SPFNotification> {
    }
}

