/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.profile;

import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import it.polimi.spf.lib.Component;
import it.polimi.spf.shared.aidl.LocalProfileService;
import it.polimi.spf.shared.model.ProfileField;
import it.polimi.spf.shared.model.ProfileFieldContainer;
import it.polimi.spf.shared.model.SPFError;

public class SPFLocalProfile
extends Component<SPFLocalProfile, LocalProfileService> {
    private static final String TAG = "LocalProfile";
    private static final Component.Descriptor<SPFLocalProfile, LocalProfileService> DESCRIPTOR = new Component.Descriptor<SPFLocalProfile, LocalProfileService>(){

        @Override
        public String getActionName() {
            return "it.polimi.spf.framework.appservice.SPFProfileService";
        }

        @Override
        public LocalProfileService castInterface(IBinder binder) {
            return LocalProfileService.Stub.asInterface((IBinder)binder);
        }

        @Override
        public SPFLocalProfile createInstance(Context context, LocalProfileService serviceInterface, ServiceConnection connection, Component.ConnectionCallback<SPFLocalProfile> callback) {
            return new SPFLocalProfile(context, serviceInterface, connection, callback);
        }
    };

    public static void load(Context context, Callback callback) {
        Component.load(context, DESCRIPTOR, callback);
    }

    private SPFLocalProfile(Context context, LocalProfileService serviceInterface, ServiceConnection connection, Component.ConnectionCallback<SPFLocalProfile> callback) {
        super(context, serviceInterface, connection, callback);
    }

    public ProfileFieldContainer getValueBulk(ProfileField<?> ... fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        SPFError err = new SPFError();
        try {
            ProfileFieldContainer pfc = ((LocalProfileService)this.getService()).getValueBulk(this.getAccessToken(), ProfileField.toIdentifierList(fields), err);
            if (err.isOk()) {
                return pfc;
            }
        }
        catch (RemoteException e) {
            this.onRemoteException(e);
            err.setCode(3);
        }
        this.handleError(err);
        Log.e((String)TAG, (String)"Remote exception @ setValueBulk");
        return null;
    }

    public boolean setValueBulk(ProfileFieldContainer container) {
        if (container == null) {
            throw new NullPointerException();
        }
        SPFError err = new SPFError();
        try {
            ((LocalProfileService)this.getService()).setValueBulk(this.getAccessToken(), container, err);
            if (err.isOk()) {
                return true;
            }
        }
        catch (RemoteException e) {
            this.onRemoteException(e);
            err.setCode(3);
        }
        this.handleError(err);
        return false;
    }

    private void onRemoteException(RemoteException e) {
        Log.e((String)TAG, (String)"Remote exception @ setValue", (Throwable)e);
        this.getCallback().onError(new SPFError(3));
    }

    public static interface Callback
    extends Component.ConnectionCallback<SPFLocalProfile> {
    }
}

