/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.profile;

import android.content.Context;
import it.polimi.spf.lib.SPF;
import it.polimi.spf.lib.SPFPerson;
import it.polimi.spf.shared.model.ProfileField;
import it.polimi.spf.shared.model.ProfileFieldContainer;
import it.polimi.spf.shared.model.SPFError;

public class SPFRemoteProfile {
    private SPF mInterface;

    public SPFRemoteProfile(Context context, SPF iface) {
        this.mInterface = iface;
    }

    public RemoteProfile getProfileOf(SPFPerson p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return new RemoteProfile(p, this.mInterface);
    }

    protected void recycle() {
        this.mInterface = null;
    }

    public class RemoteProfile {
        private SPF mInterface;
        private String mPersonIndentifier;

        public RemoteProfile(SPFPerson p, SPF iface) {
            this.mInterface = iface;
            this.mPersonIndentifier = p.getIdentifier();
        }

        public ProfileFieldContainer getProfileBulk(ProfileField<?> ... fields) {
            String[] fieldIdentifiers = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                fieldIdentifiers[i] = fields[i].getIdentifier();
            }
            SPFError err = new SPFError();
            return this.mInterface.getProfileBulk(this.mPersonIndentifier, fieldIdentifiers, err);
        }
    }
}

