/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.search;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import it.polimi.spf.lib.LooperUtils;
import it.polimi.spf.lib.SPF;
import it.polimi.spf.lib.SPFPerson;
import it.polimi.spf.shared.aidl.SPFSearchCallback;
import it.polimi.spf.shared.model.BaseInfo;
import it.polimi.spf.shared.model.SPFSearchDescriptor;
import java.util.Hashtable;
import java.util.Map;

public final class SPFSearch {
    private static final String TAG = "SPFSearch";
    private SparseArray<String> mTagToId = new SparseArray();
    private SPF mSearchInterface;
    private Map<String, SearchCallback> mCallbacks = new Hashtable<String, SearchCallback>();

    public SPFSearch(Context context, SPF searchInterface) {
        this.mSearchInterface = searchInterface;
    }

    public void startSearch(int tag, SPFSearchDescriptor searchDescriptor, SearchCallback callback) {
        if (this.mTagToId.get(tag) != null) {
            Log.d((String)"start search", (String)"mTagToId.get(tag) != null");
            String queryId = (String)this.mTagToId.get(tag);
            Log.d((String)"start search", (String)("mTagToId.get(tag)= " + (String)this.mTagToId.get(tag)));
            this.mTagToId.delete(tag);
            SearchCallback state = this.mCallbacks.remove(queryId);
            if (queryId != null && state != null) {
                Log.d((String)"start search", (String)("queryId: " + queryId + ", state: " + state));
                this.mSearchInterface.stopSearch(queryId);
                Log.d((String)"start search", (String)"stopSearch");
            }
        }
        Log.d((String)"start search", (String)"startSearch");
        this.mSearchInterface.startSearch(searchDescriptor, (SPFSearchCallback)new SPFSearchCallbackImpl(callback, tag));
    }

    public void stopSearch(int tag) {
        String queryId = (String)this.mTagToId.get(tag);
        this.mTagToId.delete(tag);
        if (queryId != null && this.mCallbacks.remove(queryId) != null) {
            this.mSearchInterface.stopSearch(queryId);
        }
    }

    public void stopAllSearches() {
        this.mTagToId.clear();
        String[] queryIds = this.mCallbacks.keySet().toArray(new String[0]);
        this.mCallbacks.clear();
        for (String queryId : queryIds) {
            this.mSearchInterface.stopSearch(queryId);
        }
    }

    public SPFPerson lookup(String identifier) {
        boolean isReachable = this.mSearchInterface.lookup(identifier);
        if (isReachable) {
            return new SPFPerson(identifier);
        }
        return null;
    }

    void onResultLost(String queryId, String uniqueIdentifier) {
        SearchCallback callback = this.mCallbacks.get(queryId);
        if (callback == null) {
            return;
        }
        callback.onPersonLost(new SPFPerson(uniqueIdentifier));
    }

    void onResultFound(String queryId, String uniqueIdentifier, BaseInfo baseInfo) {
        SearchCallback callback = this.mCallbacks.get(queryId);
        if (callback == null) {
            this.mSearchInterface.stopSearch(queryId);
            return;
        }
        SPFPerson p = new SPFPerson(uniqueIdentifier, baseInfo);
        callback.onPersonFound(p);
    }

    void onStop(String queryId) {
        SearchCallback callback = this.mCallbacks.get(queryId);
        if (callback == null) {
            return;
        }
        this.mCallbacks.remove(queryId);
        callback.onSearchStop();
    }

    void onError(String queryId) {
        SearchCallback callback = this.mCallbacks.get(queryId);
        if (callback == null) {
            this.mSearchInterface.stopSearch(queryId);
            return;
        }
        callback.onSearchError();
    }

    void onSearchStart(String queryId) {
        SearchCallback callback = this.mCallbacks.get(queryId);
        if (callback == null) {
            this.mSearchInterface.stopSearch(queryId);
            return;
        }
        callback.onSearchStart();
    }

    public void recycle() {
        this.stopAllSearches();
    }

    private final class SPFSearchCallbackImpl
    extends SPFSearchCallback.Stub {
        private final SearchCallback callback;
        private final int tag;

        private SPFSearchCallbackImpl(SearchCallback callback, int tag) {
            this.callback = callback;
            this.tag = tag;
        }

        public void onSearchStop(String queryId) throws RemoteException {
            SPFSearch.this.onStop(queryId);
        }

        public void onSearchStart(String queryId) throws RemoteException {
            if (queryId == null) {
                this.callback.onSearchError();
                return;
            }
            SearchCallback uiCallback = LooperUtils.onMainThread(SearchCallback.class, this.callback);
            SPFSearch.this.mCallbacks.put(queryId, uiCallback);
            SPFSearch.this.mTagToId.put(this.tag, (Object)queryId);
            SPFSearch.this.onSearchStart(queryId);
        }

        public void onSearchResultReceived(String queryId, String userId, BaseInfo baseInfo) throws RemoteException {
            SPFSearch.this.onResultFound(queryId, userId, baseInfo);
        }

        public void onSearchResultLost(String queryId, String userId) throws RemoteException {
            SPFSearch.this.onResultLost(queryId, userId);
        }

        public void onSearchError(String queryId) throws RemoteException {
            SPFSearch.this.onError(queryId);
        }
    }

    public static interface SearchCallback {
        public void onPersonFound(SPFPerson var1);

        public void onPersonLost(SPFPerson var1);

        public void onSearchStop();

        public void onSearchError();

        public void onSearchStart();
    }
}

