/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.services;

import android.os.Looper;
import android.util.Log;
import it.polimi.spf.lib.Utils;
import it.polimi.spf.lib.services.GsonHelper;
import it.polimi.spf.lib.services.ServiceInterface;
import it.polimi.spf.lib.services.ServiceInvocationException;
import it.polimi.spf.lib.services.ServiceValidator;
import it.polimi.spf.shared.model.InvocationRequest;
import it.polimi.spf.shared.model.InvocationResponse;
import it.polimi.spf.shared.model.SPFServiceDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;

public class InvocationStub {
    private static final String WRONG_THREAD_MSG = "Remote call to %s.%s made on the UI thread. This may hang your application.";
    private static final String TAG = "InvocationStub";
    private Target mInvocationTarget;
    private SPFServiceDescriptor mServiceDescriptor;

    static <E> E from(Class<E> serviceInterface, ClassLoader classLoader, Target target) {
        Utils.notNull(target, "target must not be null");
        Utils.notNull(serviceInterface, "descriptor must not be null");
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ServiceValidator.validateInterface(serviceInterface, 1);
        ServiceInterface service = serviceInterface.getAnnotation(ServiceInterface.class);
        SPFServiceDescriptor desc = ServiceInterface.Convert.toServiceDescriptor(service);
        InvocationStub stub = InvocationStub.from(desc, target);
        InvocationHandlerAdapter h = new InvocationHandlerAdapter(stub);
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{serviceInterface}, (InvocationHandler)h);
        return serviceInterface.cast(proxy);
    }

    static InvocationStub from(SPFServiceDescriptor descriptor, Target target) {
        Utils.notNull(target, "target must not be null");
        Utils.notNull(descriptor, "descriptor must not be null");
        return new InvocationStub(descriptor, target);
    }

    private InvocationStub(SPFServiceDescriptor descriptor, Target target) {
        this.mServiceDescriptor = descriptor;
        this.mInvocationTarget = target;
    }

    public Object invokeMethod(String methodName, Object[] args, Type retType) throws ServiceInvocationException {
        this.checkCurrentThread(methodName);
        Utils.notNull(methodName);
        Utils.notNull(args);
        this.mInvocationTarget.prepareArguments(args);
        String payload = GsonHelper.gson.toJson((Object)args);
        InvocationRequest request = new InvocationRequest(this.mServiceDescriptor.getAppIdentifier(), this.mServiceDescriptor.getServiceName(), methodName, payload);
        InvocationResponse response = this.mInvocationTarget.executeService(request);
        if (!response.isResult()) {
            throw new ServiceInvocationException(response.getErrorMessage());
        }
        if (retType.equals(Void.TYPE)) {
            return null;
        }
        return GsonHelper.gson.fromJson(response.getPayload(), retType);
    }

    private void checkCurrentThread(String methodName) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Log.w((String)TAG, (String)String.format(WRONG_THREAD_MSG, this.mServiceDescriptor.getServiceName(), methodName));
        }
    }

    private static class InvocationHandlerAdapter
    implements InvocationHandler {
        private InvocationStub mInvocationStub;

        public InvocationHandlerAdapter(InvocationStub mInvocationStub) {
            this.mInvocationStub = Utils.notNull(mInvocationStub);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ServiceInvocationException {
            return this.mInvocationStub.invokeMethod(method.getName(), args, method.getGenericReturnType());
        }
    }

    static interface Target {
        public void prepareArguments(Object[] var1) throws ServiceInvocationException;

        public InvocationResponse executeService(InvocationRequest var1) throws ServiceInvocationException;
    }
}

