/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.spf.lib.services;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import it.polimi.spf.lib.services.ActivityConsumer;
import it.polimi.spf.lib.services.GsonHelper;
import it.polimi.spf.lib.services.ServiceInterface;
import it.polimi.spf.lib.services.ServiceValidator;
import it.polimi.spf.lib.services.ServiceWrapper;
import it.polimi.spf.shared.aidl.ClientExecutionService;
import it.polimi.spf.shared.model.InvocationRequest;
import it.polimi.spf.shared.model.InvocationResponse;
import it.polimi.spf.shared.model.SPFActivity;
import it.polimi.spf.shared.model.SPFServiceDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class SPFServiceEndpoint
extends Service {
    private static final boolean DEBUG = true;
    private final String mTag;
    private Map<String, ServiceWrapper> mServiceIndex;
    private Map<String, List<Method>> mActivityConsumerIndex;
    private final ClientExecutionService.Stub mBinder = new ClientExecutionService.Stub(){

        public InvocationResponse executeService(InvocationRequest request) throws RemoteException {
            SPFServiceEndpoint.this.log("Performing execution request of " + request.getMethodName());
            return SPFServiceEndpoint.this.doExecuteService(request);
        }

        public InvocationResponse sendActivity(SPFActivity activity) throws RemoteException {
            SPFServiceEndpoint.this.log("Dispatching activity " + activity + " to consumers");
            return SPFServiceEndpoint.this.doSendActivity(activity);
        }
    };

    protected SPFServiceEndpoint() {
        this.mTag = ((Object)((Object)this)).getClass().getSimpleName();
        this.mServiceIndex = new Hashtable<String, ServiceWrapper>();
        this.mActivityConsumerIndex = new HashMap<String, List<Method>>();
        ArrayList serviceInterfaces = new ArrayList();
        for (Class<?> iface : ((Object)((Object)this)).getClass().getInterfaces()) {
            if (!iface.isAnnotationPresent(ServiceInterface.class)) continue;
            ServiceValidator.validateInterface(iface, 0);
            serviceInterfaces.add(iface);
        }
        if (serviceInterfaces.size() == 0) {
            this.log("ExecutionEndpointService does not implement any ServiceInterface.");
            return;
        }
        for (Class clazz : serviceInterfaces) {
            ServiceInterface annotation = clazz.getAnnotation(ServiceInterface.class);
            SPFServiceDescriptor d = ServiceInterface.Convert.toServiceDescriptor(annotation);
            ServiceWrapper w = new ServiceWrapper(clazz, (Object)this);
            this.mServiceIndex.put(d.getServiceName(), w);
            for (String v : d.getConsumedVerbs()) {
                if (this.mActivityConsumerIndex.containsKey(v)) continue;
                this.mActivityConsumerIndex.put(v, new ArrayList());
            }
        }
        for (Method m : ((Object)((Object)this)).getClass().getMethods()) {
            if (!m.isAnnotationPresent(ActivityConsumer.class)) continue;
            ActivityConsumer c = m.getAnnotation(ActivityConsumer.class);
            List<Method> consumers = this.mActivityConsumerIndex.get(c.verb());
            if (consumers == null) {
                this.log("Verb " + c.verb() + " is not declared in service annotation");
                continue;
            }
            consumers.add(m);
        }
    }

    private InvocationResponse doExecuteService(InvocationRequest request) {
        String svcName = request.getServiceName();
        if (!this.mServiceIndex.containsKey(svcName)) {
            return InvocationResponse.error((String)("Service " + svcName + " not found in index."));
        }
        return this.mServiceIndex.get(svcName).invokeMethod(request);
    }

    private InvocationResponse doSendActivity(SPFActivity activity) {
        List<Method> consumers = this.mActivityConsumerIndex.get(activity.getVerb());
        if (consumers == null) {
            this.log("Received unexpected activity verb: " + activity.getVerb());
            return InvocationResponse.error((String)"Unsupported activity verb");
        }
        if (consumers.size() == 0) {
            this.log("No consumers for declared verb " + activity.getVerb());
            return InvocationResponse.error((String)("No consumer available for verb " + activity.getVerb()));
        }
        Object[] args = new Object[]{activity};
        for (Method m : consumers) {
            try {
                m.invoke((Object)this, args);
            }
            catch (Exception e) {
                this.log("Error invoking consumer method " + m.getName(), e);
            }
        }
        String json = GsonHelper.gson.toJson((Object)Boolean.TRUE);
        return InvocationResponse.result((String)json);
    }

    private void log(String msg) {
        Log.d((String)this.mTag, (String)msg);
    }

    private void log(String msg, Throwable t) {
        Log.e((String)this.mTag, (String)msg, (Throwable)t);
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }
}

